<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class FixMigration extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:fix-migration';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $migrationPath = database_path('migrations');
        $migrationFiles = glob($migrationPath . '/*.php');

        DB::table('migrations')->truncate();

        foreach ($migrationFiles as $migrationFile) {
            $filename = basename($migrationFile, '.php');
            echo 'Adding migration: ' . $filename . "\n";

            DB::table('migrations')->insert([
                'migration' => $filename,
                'batch' => 1,
            ]);

            $this->components->info('Migration added: ' . $filename);
        }
    }
}
