<?php

namespace App\Console\Commands;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Console\Command;
use Spatie\Sitemap\Sitemap;
use Spatie\Sitemap\Tags\Url;

class SitemapGenerate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sitemap:generate';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Automatically Generate an XML Sitemap';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $sitemap = Sitemap::create();

        $frequency = Url::CHANGE_FREQUENCY_DAILY;

        $staticPageUrls = [
            ['url' => '/', 'priority' => 0.9],
            ['url' => '/categories', 'priority' => 0.9],
            ['url' => '/shops', 'priority' => 0.9],
            ['url' => '/products', 'priority' => 0.9],
            ['url' => '/most-popular', 'priority' => 0.9],
            ['url' => '/best-deal', 'priority' => 0.9],
            ['url' => '/contact-us', 'priority' => 0.8],
            ['url' => '/faq', 'priority' => 0.8],
            ['url' => '/page/return-and-refund-policy', 'priority' => 0.8],
            ['url' => '/page/shipping-and-delivery-policy', 'priority' => 0.8],
            ['url' => '/terms-and-conditions', 'priority' => 0.8],
            ['url' => '/privacy-policy', 'priority' => 0.8],
            ['url' => '/about-us', 'priority' => 0.8],
            ['url' => '/download-app', 'priority' => 0.8],
            ['url' => '/shop/register', 'priority' => 0.8],
            ['url' => '/shop', 'priority' => 0.7],
        ];

        foreach ($staticPageUrls as $staticPage) {
            $sitemap->add(
                Url::create($staticPage['url'])->setPriority($staticPage['priority'])->setChangeFrequency($frequency)
            );
        }

        Category::get()->each(function ($category) use ($sitemap, $frequency) {
            $url = '/categories/'.$category->id;
            $sitemap->add(
                Url::create($url)->setPriority(0.8)->setChangeFrequency($frequency)
            );
        });

        Product::get()->each(function ($product) use ($sitemap, $frequency) {
            $url = '/products/'.($product->slug ?? $product->id).'/details';
            $sitemap->add(
                Url::create($url)->setPriority(0.9)->setChangeFrequency($frequency)
            );
        });

        $sitemap->writeToFile(public_path('sitemap.xml'));

        return Command::SUCCESS;
    }
}
