<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Resources\CityResource;
use App\Http\Resources\CountryResource;
use App\Models\Country;

class CountryController extends Controller
{
    public function index()
    {
        $countries = Country::all();

        return $this->json('all countries', [
            'countries' => CountryResource::collection($countries),
        ], 200);
    }

    public function cities($id)
    {
        $country = Country::with('cities')->where('id', $id)->orWhere('name', $id)->first();

        $cities = $country?->cities ?? [];

        return $this->json('cities', [
            'cities' => CityResource::collection($cities),
        ], 200);
    }
}
