<?php

namespace App\Http\Controllers;

use App\Enums\Roles;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Shop;
use App\Models\User;
use App\Models\Wallet;

class CreateSuperAdmin extends Controller
{
    public function index()
    {
        return view('create-root');
    }

    public function store(Request $request)
    {
        $request->validate([
            'email' => 'required|email|unique:users,email',
            'password' => 'required|min:8|confirmed',
        ]);

        $rootUser = User::factory()->create([
            'name' => 'Administrator',
            'email' => $request->email,
            'phone' => fake()->phoneNumber(),
            'is_active' => true,
            'password' => bcrypt($request->password),
        ]);
        $rootUser->assignRole(Roles::ROOT->value);

        Shop::factory()->create([
            'user_id' => $rootUser->id,
            'name' => 'My Shop',
            'delivery_charge' => 0,
            'description' => 'My Shop Description',
            'status' => true,
            'min_order_amount' => 1,
        ]);

        $rootUser->assignRole(Roles::SHOP->value);

        Wallet::create([
            'user_id' => $rootUser->id,
            'balance' => 0,
        ]);

        // Redirect to the dashboard or any other page
        return redirect()->route('admin.login')->with('success', 'You are ready to use MeyaMart! Please login with your credentials.');
    }
}
