<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class GuestBuyNowStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'product_id' => 'required|exists:products,id',
            'quantity' => 'nullable|integer',
            'coupon_code' => 'nullable|string|max:50',
            'shipping.name' => 'required|string|max:255',
            'shipping.country' => 'required|string|max:255',
            'shipping.phone_code' => 'required|string|max:255',
            'shipping.phone' => 'required|numeric|digits_between:9,16',
            'shipping.area' => 'required|string|max:255',
            'shipping.flat_no' => 'nullable|string|max:255',
            'shipping.post_code' => 'nullable|string|max:255',
            'shipping.address_line' => 'required|string|max:255',
            'shipping.address_line2' => 'nullable|string|max:255',
            'shipping.address_type' => 'nullable|string|max:255',
            'shipping.longitude' => 'nullable|numeric|max:255',
            'shipping.latitude' => 'nullable|numeric|max:255',
            'note' => 'nullable|string',
            'payment_method' => 'required|string',
            'color' => 'nullable|string',
            'size' => 'nullable|string',
            'unit' => 'nullable|string',
        ];
    }

    public function messages(): array
    {
        $request = request();
        if ($request->is('api/*')) {
            $lan = $request->header('accept-language') ?? 'en';
            app()->setLocale($lan);
        }

        return [
            'product_id.required' => __('The product field is required.'),
            'product_id.exists' => __('The selected product is invalid.'),
            'quantity.integer' => __('The quantity must be an integer.'),
            'shipping.name.required' => __('The name field is required'),
            'shipping.name.max' => __('The name may not be greater than 255 characters'),
            'shipping.name.string' => __('The name must be a string'),
            'shipping.country.required' => __('The country field is required'),
            'shipping.country.string' => __('The country must be a string'),
            'shipping.country.max' => __('The country may not be greater than 255 characters'),
            'shipping.phone.required' => __('The phone field is required.'),
            'shipping.phone.numeric' => __('The phone must be a valid phone number.'),
            'shipping.phone.digits_between' => __('The phone must be between 9 and 16 digits.'),
            'shipping.area.required' => __('The area field is required'),
            'shipping.area.max' => __('The area may not be greater than 255 characters'),
            'shipping.address_type.required' => __('The address type field is required'),
            'shipping.address_type.max' => __('The address type may not be greater than 255 characters'),
            'shipping.post_code.required' => __('The post code field is required'),
            'shipping.post_code.max' => __('The post code may not be greater than 255 characters'),
            'shipping.flat_no.max' => __('The flat no may not be greater than 255 characters'),
            'shipping.address_line.required' => __('The address line field is required'),
            'shipping.address_line.max' => __('The address line may not be greater than 255 characters'),
            'shipping.address_line2.max' => __('The address line 2 may not be greater than 255 characters'),
            'payment_method.required' => __('The payment method field is required.'),
        ];
    }
}
