<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class MultiCartRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'products' => 'required|array',
            'products.*.product_id' => 'required|exists:products,id',
            'products.*.quantity' => 'nullable|integer|min:1',
            'products.*.color' => 'nullable|exists:colors,id',
            'products.*.size' => 'nullable|exists:sizes,id',
        ];
    }

    public function messages(): array
    {
        $request = request();
        if ($request->is('api/*')) {
            $lan = $request->header('accept-language') ?? 'en';
            app()->setLocale($lan);
        }

        return [
            'products.*.product_id.required' => __('The product field is required.'),
            'products.*.product_id.exists' => __('The selected product id is invalid.'),
            'products.*.quantity.integer' => __('The quantity must be an integer.'),
            'products.*.quantity.min' => __('The quantity must be at least 1'),
            'products.*.color.exists' => __('The selected color is invalid.'),
            'products.*.size.exists' => __('The selected size is invalid.'),
        ];
    }
}
