<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BrandResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $lang = request()->header('accept-language') ?? 'en';
        $translation = null;
        if ($lang != 'en') {
            $translation = $this->translations()?->where('lang', $lang)->first();
        }

        return [
            'id' => $this->id,
            'name' => $translation ? $translation->name : $this->name,
        ];
    }
}
