<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $lang = request()->header('accept-language') ?? 'en';

        $translate = null;
        if ($lang != 'en') {
            $translate = $this->translations()?->where('lang', $lang)->first();
        }

        return [
            'id' => $this->id ?? null,
            'name' => $translate ? $translate->name : ($this->name ?? null),
            'thumbnail' => $this->thumbnail ?? null,
            'sub_categories' => SubCategoryResource::collection($this->subCategories ?? []),
        ];
    }
}
