<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Color extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    /**
     * Scope a query to only include active colors.
     */
    public function scopeIsActive($query)
    {
        return $query->where('is_active', 1);
    }

    public function translations(): HasMany
    {
        return $this->hasMany(TranslateUtility::class);
    }
}
