<?php

return [
    'permissions' => [
        'adminMultiShop' => [
            'shop' => ['index', 'create', 'edit', 'status.toggle', 'show', 'orders', 'products', 'reset.password'],
            'product' => ['index', 'approve', 'show', 'destroy'],
            'coupon' => ['index', 'create', 'edit', 'destroy'],
            'withdraw' => ['index', 'update', 'show'],
        ],
        'admin' => [
            'dashboard' => ['index', 'notification'],
            'banner' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'ad' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'order' => ['index', 'show', 'status.change', 'payment.status.toggle', 'assign.rider'],
            'review' => ['index', 'toggle'],
            'brand' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'color' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'size' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'unit' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'category' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'subcategory' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'flashSale' => ['index', 'create', 'edit', 'destroy', 'toggle'],
            'legalpage' => ['index', 'edit'],
            'generale-setting' => ['index', 'update'],
            'business-setting' => ['index', 'update'],
            'verification' => ['index', 'update'],
            'socialLink' => ['index', 'update'],
            'socialAuth' => ['index', 'update', 'toggle'],
            'themeColor' => ['index', 'update', 'change'],
            'deliveryCharge' => ['index', 'create', 'edit', 'destroy'],
            'pusher' => ['index', 'update'],
            'mailConfig' => ['index', 'update'],
            'paymentGateway' => ['index', 'update', 'toggle'],
            'sms-gateway' => ['index', 'update'],
            'googleReCaptcha' => ['index', 'update'],
            'contactUs' => ['index', 'update'],
            'firebase' => ['index', 'update'],
            'profile' => ['index', 'update', 'change-password'],
            'rider' => ['index', 'create', 'show', 'edit', 'destroy', 'toggle', 'assign.order'],
            'customer' => ['index', 'create', 'show', 'edit', 'destroy', 'toggle'],
            'customerNotification' => ['index', 'send'],
            'language' => ['index', 'create', 'edit', 'destroy', 'export', 'import'],
            'employee' => ['index', 'create', 'edit', 'destroy', 'toggle', 'reset.password', 'permission', 'permission.update'],
            'role' => ['index', 'create', 'edit', 'destroy', 'permission', 'permission.update'],
            'ticketissuetype' => ['index', 'create', 'edit', 'toggle', 'delete'],
            'supportTicket' => ['index', 'show', 'setScheduled', 'sendMessage', 'updateStatus', 'pinMessage', 'chatToggle'],
            'support' => ['index', 'destroy'],
            'vatTax' => ['index', 'order.update', 'store', 'update', 'toggle', 'destroy'],
            'currency' => ['index', 'store', 'update', 'toggle', 'destroy'],
        ],
        'shop' => [
            'order' => ['index', 'show', 'status.change'],
            'product' => ['index', 'create', 'show', 'edit', 'toggle', 'destroy', 'barcode', 'recommended', 'recommended.update'],
            'flashSale' => ['index', 'show', 'productStore', 'productRemove', 'product.edit'],
            'voucher' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'bulk-product-import' => ['index', 'store'],
            'bulk-product-export' => ['index', 'demo', 'export'],
            'gallery' => ['index', 'store'],
            'gift' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'pos' => ['index', 'sales', 'draft'],
            'employee' => ['index', 'create', 'edit', 'destroy', 'toggle', 'reset.password', 'permission', 'permission.update'],
            'profile' => ['index', 'edit', 'change-password'],
        ],
        'shopMultiShop' => [
            'dashboard' => ['index', 'notification'],
            'brand' => ['index'],
            'color' => ['index'],
            'size' => ['index'],
            'unit' => ['index'],
            'category' => ['index'],
            'subcategory' => ['index'],
            'withdraw' => ['index', 'store', 'show'],
        ],
    ],

    // only for human readable permissions names
    'customerReadableNames' => [
        'index' => 'list',
        'destroy' => 'delete',
        'toggle' => 'enable/disable',
        'status.toggle' => 'enable/disable',
        'reset.password' => 'reset password',
        'show' => 'view details',
        'permission.update' => 'update permission',
        'voucher' => 'Promo Code',
        'bulk-product-import' => 'bulk product import',
        'store' => 'create',
        'bulk-product-export' => 'bulk product export',
        'gallery' => 'gallery import',
        'status.change' => 'change status',
        'payment.status.toggle' => 'payment update',
        'assign.rider' => 'assign rider',
        'subcategory' => 'sub category',
        'generale-setting' => 'general setting',
        'business-setting' => 'business setting',
        'socialLink' => 'social link',
        'themeColor' => 'theme color',
        'deliveryCharge' => 'delivery charge',
        'pusher' => 'pusher config',
        'mailConfig' => 'mail config',
        'paymentGateway' => 'payment gateway',
        'sms-gateway' => 'sms gateway',
        'contactUs' => 'contact us',
        'firebase' => 'firebase config',
        'change-password' => 'change password',
        'assign.order' => 'assign order',
        'customer' => 'customer',
        'customerNotification' => 'customer notification',
        'language' => 'Language Settings',
        'ticketissuetype' => 'ticket issue type',
        'supportTicket' => 'support ticket',
        'updateStatus' => 'status update',
        'chatToggle' => 'chat enable/disable',
        'support' => 'contact messages',
        'role' => 'roles & permissions',
        'socialAuth' => 'social login',
        'productStore' => 'product store',
        'productRemove' => 'product remove',
        'product.edit' => 'product edit',
        'googleReCaptcha' => 'google reCAPTCHA',
        'vatTax' => 'VAT & Tax',
        'flashSale' => 'flash sale',
        'order.update' => 'Order base tax update',
        'recommended' => 'recommended products',
        'recommended.update' => 'update recommended products',
    ],
];
