<?php

namespace Database\Seeders;

use App\Models\SocialLink;
use Illuminate\Database\Seeder;

class SocialLinkSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        SocialLink::truncate();

        $data = [
            [
                'link' => 'https://www.facebook.com/supplymaster.store',
                'logo' => '/assets/icons/facebook.svg',
                'name' => 'Facebook',
            ],
            [
                'link' => 'https://www.linkedin.com/company/razinsoft',
                'logo' => '/assets/icons/linkedIn.svg',
                'name' => 'LinkedIn',
            ],
            [
                'link' => 'https://api.whatsapp.com/send?phone=233540715156',
                'logo' => '/assets/icons/instagram.svg',
                'name' => 'Instagram',
            ],
            [
                'link' => 'https://www.youtube.com/@supplymaster2415',
                'logo' => '/assets/icons/youTube.svg',
                'name' => 'YouTube',
            ],
            [
                'link' => 'https://api.whatsapp.com/send?phone=233540715156',
                'logo' => '/assets/icons/whatsapp.svg',
                'name' => 'WhatsApp',
            ],
            [
                'link' => 'https://www.tiktok.com/@supply.master',
                'logo' => '/assets/icons/tikTok.svg',
                'name' => 'TikTok',
            ],
            [
                'link' => 'https://x.com/supplymaster_',
                'logo' => '/assets/icons/twitter.svg',
                'name' => 'Twitter',
            ],
        ];

        SocialLink::insert($data);
    }
}
