import { defineStore } from "pinia";
import { useMaster } from "./MasterStore";

export const useGuestStore = defineStore("guestStore", {
    state: () => ({
        carts: [],
        collectedCoupons: [],
        updatedAt: Date.now(),
    }),

    actions: {
        getCarts() {
            this.resetData();
            return this.carts;
        },

        getColllectedCoupons() {
            this.resetData();
            return this.collectedCoupons;
        },

        updateCarts(carts) {
            this.carts = carts;
            this.updatedAt = Date.now();
            return this.carts;
        },

        updateCollectedCoupons(coupons) {
            this.collectedCoupons = coupons;
            this.updatedAt = Date.now();
            return this.collectedCoupons;
        },

        resetData() {
            const masterStore = useMaster();

            if (this.updatedAt < Date.now() - masterStore.resetGuestCartAfter) {
                this.carts = [];
                this.collectedCoupons = [];
            }
        },
    },

    persist: true,
});
