import { defineStore } from "pinia";

export const useMaster = defineStore("masterStore", {
    state: () => ({
        locale: "en",
        langDirection: "ltr",
        defaultLocale: "en",
        logo: null,
        currency: {
            symbol: "$",
            position: "prefix",
            name: "USD",
        },
        defaultCurrency: "USD",
        selectedCurrency: null,
        currencies: [],
        appName: "",
        showDownloadApp: false,
        playStoreLink: null,
        appStoreLink: null,
        multiVendor: true,
        paymentGateways: [],
        mobile: null,
        email: null,
        showFooter: true,
        address: null,
        footerText: null,
        footerDescription: null,
        footerLogo: null,
        footerQr: null,
        socialLinks: [],
        basketCanvas: false,
        search: null,
        categories: [],
        themeColors: {
            primary: null,
            primary50: null,
            primary100: null,
            primary200: null,
            primary300: null,
            primary400: null,
            primary500: null,
            primary600: null,
            primary700: null,
            primary800: null,
            primary900: null,
            primary950: null,
        },
        pusher_app_key: null,
        pusher_app_cluster: null,
        app_environment: "local",
        register_otp_verify: false,
        register_otp_type: null,
        forgot_otp_type: null,
        languages: [],
        socialAuths: [],
        resetGuestCartAfter: null,
    }),

    getters: {
        getPosition: (state) => {
            return state.position;
        },

        getPlayStoreLink: (state) => {
            return state.playStoreLink;
        },

        getAppStoreLink: (state) => {
            return state.appStoreLink;
        },
        getMultiVendor: (state) => {
            return state.multiVendor;
        },
    },

    actions: {
        fetchData() {
            axios.get("/master").then((response) => {
                this.currency = response.data.data.currency;
                this.currencies = response.data.data.currencies;
                this.appName = response.data.data.app_name;
                this.playStoreLink = response.data.data.google_playstore_link;
                this.appStoreLink = response.data.data.app_store_link;
                this.multiVendor = response.data.data.multi_vendor;
                this.mobile = response.data.data.mobile;
                this.email = response.data.data.email;
                this.showFooter = response.data.data.web_show_footer;
                this.address = response.data.data.address;
                this.paymentGateways = response.data.data.payment_gateways;
                this.footerText = response.data.data.web_footer_text;
                this.footerDescription =
                    response.data.data.web_footer_description;
                this.footerLogo = response.data.data.web_footer_logo;
                this.footerQr = response.data.data.footer_qr;
                this.logo = response.data.data.web_logo;
                this.socialLinks = response.data.data.social_links;
                this.themeColors = response.data.data.theme_colors;
                this.pusher_app_key = response.data.data.pusher_app_key;
                this.pusher_app_cluster = response.data.data.pusher_app_cluster;
                this.app_environment = response.data.data.app_environment;
                this.showDownloadApp = response.data.data.show_download_app;
                this.register_otp_verify =
                    response.data.data.register_otp_verify;
                this.register_otp_type = response.data.data.register_otp_type;
                this.forgot_otp_type = response.data.data.forgot_otp_type;
                this.languages = response.data.data.languages;
                this.socialAuths = response.data.data.social_auths;
                this.resetGuestCartAfter = 2 * 60 * 60 * 1000;

                if (this.defaultLocale != response.data.data.app_locale) {
                    this.locale = response.data.data.app_locale;
                    this.defaultLocale = response.data.data.app_locale;
                    const defaultLanguage = this.languages.find((language) => language.name == this.locale);
                    if (defaultLanguage) {
                        this.langDirection = defaultLanguage.direction ?? "ltr";
                    }
                    window.location.reload();
                }

                const defaultCurrency = this.currencies.find((currency) => currency.is_default == true);
                if (this.defaultCurrency != this.currency.name) {
                    this.defaultCurrency = this.currency.name;
                    this.setSelectedCurrency(defaultCurrency);
                } else if (!this.selectedCurrency) {
                    this.setSelectedCurrency(defaultCurrency ?? null);
                }
            });
        },

        setSelectedCurrency(defaultCurrency = null) {
            if (defaultCurrency) {
                this.selectedCurrency = defaultCurrency;
            } else {
                this.selectedCurrency.name = this.currency?.name ?? "USD";
                this.selectedCurrency.symbol = this.currency?.symbol ?? "$";
                this.selectedCurrency.rate = this.currency?.rate ?? 1;
            }
        },

        showCurrency(amount) {

            const currentRateFromDefault = this.selectedCurrency?.rate_from_default ?? 1;

            amount = parseFloat(amount * currentRateFromDefault).toFixed(2);

            if (this.currency.position == "prefix") {
                return (this.selectedCurrency?.symbol ?? "$") + amount;
            }
            return amount + (this.selectedCurrency?.symbol ?? "$");
        },
    },

    persist: true,
});
