@extends('layouts.app')
@section('content')
    <div class="d-flex align-items-center flex-wrap gap-3 justify-content-between px-3">
        <h4>
            {{ __('City List') }}
        </h4>
    </div>

    <div class="container-fluid mt-3">

        <div class="mb-3 card">
            <div class="card-body">

                <form action="" class="d-flex align-items-center justify-content-between gap-3 mb-3">
                    <div class="input-group" style="max-width: 400px">
                        <input type="text" name="search" class="form-control" placeholder="{{ __('Search by name') }}"
                            value="{{ request('search') }}">
                        <button type="submit" class="input-group-text btn btn-primary">
                            <i class="fa fa-search"></i> {{ __('Search') }}
                        </button>
                    </div>
                    <button type="button" data-bs-toggle="modal" data-bs-target="#createCity" class="btn py-2 btn-primary">
                        <i class="fa fa-plus-circle"></i>
                        {{ __('Create New') }}
                    </button>
                </form>

                <div class="table-responsive">
                    <table class="table border table-responsive-lg">
                        <thead>
                            <tr>
                                <th class="text-center">{{ __('SL') }}</th>
                                <th>{{ __('Name') }}</th>
                                <th>{{ __('Country') }}</th>
                                <th>{{ __('Delivery Charge') }}</th>
                                <th>
                                    {{ __('Max Amount') }} <br>
                                    <small class="text-muted fs-10">({{ __('when order amount is greater than charge is 0') }})</small>
                                </th>
                                <th class="text-center">{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        @forelse($cities as $key => $city)
                            <tr>
                                <td class="text-center">{{ ++$key }}</td>

                                <td>{{ $city->name }}</td>

                                <td>{{ $city->country?->name }}</td>
                                <td>
                                    {{ showCurrency($city->delivery_charge) }}
                                </td>
                                <td>
                                    {{ showCurrency($city->amount) }}
                                </td>

                                <td class="text-center">
                                    <div class="d-flex gap-2 justify-content-center">
                                        <button type="button" class="btn btn-outline-primary circleIcon btn-sm"
                                            onclick="openCityUpdateModal({{ $city }})">
                                            <i class="fa-solid fa-pen"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td class="text-center" colspan="100%">{{ __('No Data Found') }}</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="my-3">
            {{ $cities->links() }}
        </div>

    </div>

    <!--=== Create Color Modal ===-->
    <form action="{{ route('admin.city.store') }}" method="POST">
        @csrf
        <div class="modal fade" id="createCity" style="overflow: hidden">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">
                            {{ __('Add New City') }}
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="name" class="form-label">
                                {{ __('Name') }}
                                <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control" id="name" name="name"
                                placeholder="{{ __('Enter name') }}" required />
                            @error('name')
                                <p class="text text-danger m-0">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="countryCreate" class="form-label">
                                {{ __('Country') }}
                                <span class="text-danger">*</span>
                            </label>
                            <select name="country_id" id="countryCreate" class="form-control select2Modal" required
                                style="width: 100%">
                                @foreach ($countries as $country)
                                    <option value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                            @error('country')
                                <p class="text text-danger m-0">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="delivery_charge" class="form-label">
                                {{ __('Delivery Charge') }}
                                <span class="text-danger">*</span>
                            </label>
                            <small class="text-muted fs-10">
                                {{ __('(When delivery charge is 0 that means free shipping)') }}
                            </small>
                            <input type="number" id="delivery_charge" name="delivery_charge" class="form-control"
                                min="0" required placeholder="{{ __('Enter Delivery Charge') }}" />
                            @error('country')
                                <p class="text text-danger m-0">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="max_amount" class="form-label">
                                {{ __('Max Amount') }}
                                <span class="text-danger">*</span>
                            </label>
                            <small class="text-muted fs-10">
                                {{ __('(When order amount is greater than or equal to max amount then delivery charge is 0)') }}
                            </small>
                            <input type="number" id="max_amount" name="max_amount" class="form-control" min="0"
                                required placeholder="{{ __('Enter Max Amount') }}" value="0" />
                            @error('max_amount')
                                <p class="text text-danger m-0">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            {{ __('Close') }}
                        </button>
                        <button type="submit" class="btn btn-primary">
                            {{ __('Submit') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--=== update color Modal ===-->
    <form action="" id="updateCityForm" method="POST">
        @csrf
        @method('PUT')
        <div class="modal fade" id="updateCity" style="overflow: hidden">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('Update City') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="update_name" class="form-label">
                                {{ __('Name') }}
                                <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control" id="update_name" name="name"
                                placeholder="{{ __('Enter name') }}" required />
                            @error('name')
                                <p class="text text-danger m-0">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="update_country" class="form-label">
                                {{ __('Country') }}
                                <span class="text-danger">*</span>
                            </label>
                            <select name="country_id" id="update_country" class="form-control select2Modal" required
                                style="width: 100%">
                                @foreach ($countries as $country)
                                    <option value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                            @error('country')
                                <p class="text text-danger m-0">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="update_delivery_charge" class="form-label">
                                {{ __('Delivery Charge') }}
                                <span class="text-danger">*</span>
                            </label>
                            <small class="text-muted fs-10">
                                {{ __('(When delivery charge is 0 that means free shipping)') }}
                            </small>
                            <input type="number" id="update_delivery_charge" name="delivery_charge" class="form-control"
                                min="0" required placeholder="{{ __('Enter Delivery Charge') }}" />
                            @error('country')
                                <p class="text text-danger m-0">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="max_amount" class="form-label">
                                {{ __('Max Amount') }}
                                <span class="text-danger">*</span>
                            </label>
                            <small class="text-muted fs-10">
                                {{ __('(When order amount is greater than or equal to max amount then delivery charge is 0)') }}
                            </small>
                            <input type="number" id="update_max_amount" name="max_amount" class="form-control" min="0"
                                required placeholder="{{ __('Enter Max Amount') }}" value="0" />
                            @error('max_amount')
                                <p class="text text-danger m-0">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            {{ __('Close') }}
                        </button>
                        <button type="submit" class="btn btn-primary">
                            {{ __('Update') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
@push('css')
    <style>
        .fs-10 {
            font-size: 11px;
        }
    </style>
@endpush
@push('scripts')
    <script>
        const openCityUpdateModal = (city) => {

            $("#update_name").val(city.name);
            $("#update_delivery_charge").val(city.delivery_charge);
            $("#update_max_amount").val(city.max_amount);
            $("#update_country").val(city.country_id).trigger('change');

            $("#updateCityForm").attr('action', `{{ route('admin.city.update', ':id') }}`.replace(':id', city.id));
            $("#updateCity").modal('show');
        }

        $(document).ready(function() {
            $('.select2Modal').select2({
                dropdownParent: $('#createCity .modal-content')
            });
        });
    </script>
@endpush
