@extends('layouts.app')
@section('content')
    <div class="d-flex align-items-center flex-wrap gap-3 justify-content-between px-3">

        <h4>
            {{ __('Color List') }}
        </h4>

        @hasPermission('admin.color.create')
        <button type="button" data-bs-toggle="modal" data-bs-target="#createBrand" class="btn py-2 btn-primary">
            <i class="fa fa-plus-circle"></i>
            {{__('Create New')}}
        </button>
        @endhasPermission
    </div>

    <div class="container-fluid mt-3">

        <div class="mb-3 card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-responsive-md">
                        <thead>
                            <tr>
                                <th class="text-center">{{ __('SL') }}</th>
                                <th>{{ __('Name') }}</th>
                                <th>{{ __('Color') }}</th>
                                @hasPermission('admin.color.toggle')
                                <th>{{ __('Status') }}</th>
                                @endhasPermission
                                @hasPermission('admin.color.edit')
                                <th class="text-center">{{ __('Action') }}</th>
                                @endhasPermission
                            </tr>
                        </thead>
                        @forelse($colors as $key => $color)
                            @php
                                $serial = $colors->firstItem() + $key;
                                $translations = $color->translations ?? [];
                            @endphp
                            <tr>
                                <td class="text-center">{{ $serial }}</td>
                                <td>{{ $color->name }}</td>

                                <td>
                                    <div style="width: 42px; height: 28px; border-radius: 4px; background: {{ $color->color_code }}"></div>
                                </td>

                                @hasPermission('admin.color.toggle')
                                <td>
                                    <label class="switch mb-0">
                                        <a href="{{ route('admin.color.toggle', $color->id) }}">
                                            <input type="checkbox" {{ $color->is_active ? 'checked' : '' }}>
                                            <span class="slider round"></span>
                                        </a>
                                    </label>
                                </td>
                                @endhasPermission

                                @hasPermission('admin.color.edit')
                                <td class="text-center">
                                    <div class="d-flex gap-3 justify-content-center">
                                        <button type="button" class="btn btn-outline-primary circleIcon btn-sm" onclick="openColorUpdateModal({{ $color }}, {{ $translations }})">
                                            <i class="fa-solid fa-pen"></i>
                                        </button>

                                    </div>
                                </td>
                                @endhasPermission
                            </tr>
                        @empty
                            <tr>
                                <td class="text-center" colspan="100%">{{ __('No Data Found') }}</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="my-3">
            {{ $colors->withQueryString()->links() }}
        </div>

    </div>


    <!--=== Create Color Modal ===-->
    <form action="{{ route('admin.color.store') }}" method="POST">
        @csrf
        <div class="modal fade" id="createBrand" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">
                            {{ __('Create New Color') }}
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">

                        <ul class="nav nav-pills languageTab mt-3" id="pills-tab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="pills-english-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-english" type="button" role="tab"
                                    aria-controls="pills-english" aria-selected="true">
                                    {{ __('English(EN)') }}
                                </button>
                            </li>
                            @foreach ($allLanguages as $language)
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="pills-{{ $language->name }}-tab" data-bs-toggle="pill"
                                        data-bs-target="#pills-{{ $language->name }}" type="button" role="tab"
                                        aria-controls="pills-{{ $language->name }}" aria-selected="false">
                                        {{ __($language->title . '(' . $language->name . ')') }}
                                    </button>
                                </li>
                            @endforeach
                        </ul>
                        <div class="tab-content mb-3" id="pills-tabContent">
                            <div class="tab-pane fade show active mt-2" id="pills-english" role="tabpanel"
                                aria-labelledby="pills-english-tab" tabindex="0">
                                <x-input label="Name (EN)" name="name" type="text" placeholder="Enter Name"
                                    required="true" />
                            </div>
                            @foreach ($allLanguages as $language)
                                <div class="tab-pane fade mt-2" id="pills-{{ $language->name }}" role="tabpanel"
                                    aria-labelledby="pills-{{ $language->name }}-tab" tabindex="0">
                                    <x-input :label="'Name (' . $language->name . ')'" name="names[{{ $language->name }}]" type="text" :placeholder="'Enter Name (' . $language->name . ')'" />
                                </div>
                            @endforeach
                        </div>

                        <div class="mb-3 d-flex align-items-center gap-3">
                            <label for="color_code" class="form-label m-0">
                                {{ __('Select Color') }}
                                <span class="text-danger">*</span>
                            </label>
                            <input type="color" id="color_code" name="color_code"  style="width: 120px;height: 40px"/>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            {{ __('Close') }}
                        </button>
                        <button type="submit" class="btn btn-primary">
                            {{ __('Submit') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--=== update color Modal ===-->
    <form action="" id="updateColor" method="POST">
        @csrf
        @method('PUT')
        <div class="modal fade" id="updateBrand" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">
                            {{ __('Update Color') }}
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">

                        <ul class="nav nav-pills languageTab mt-3" id="pills-tab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="pills-english-edit-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-english-edit" type="button" role="tab"
                                    aria-controls="pills-english-edit" aria-selected="true">
                                    {{ __('English(EN)') }}
                                </button>
                            </li>
                            @foreach ($allLanguages as $language)
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="pills-{{ $language->name }}-edit-tab" data-bs-toggle="pill"
                                        data-bs-target="#pills-{{ $language->name }}-edit" type="button" role="tab"
                                        aria-controls="pills-{{ $language->name }}-edit" aria-selected="false">
                                        {{ __($language->title . '(' . $language->name . ')') }}
                                    </button>
                                </li>
                            @endforeach
                        </ul>
                        <div class="tab-content mb-3" id="pills-tabContent">
                            <div class="tab-pane fade show active mt-2" id="pills-english-edit" role="tabpanel"
                                aria-labelledby="pills-english-edit-tab" tabindex="0">
                                <label for="name" class="form-label">{{ __('Name (EN)') }} *</label>
                                <input type="text" class="form-control" id="updateName" name="name"
                                    placeholder="Enter Name" value="" required />
                                @error('name')
                                    <p class="text text-danger m-0">{{ $message }}</p>
                                @enderror
                            </div>
                            @foreach ($allLanguages as $language)
                                <div class="tab-pane fade mt-2" id="pills-{{ $language->name }}-edit" role="tabpanel"
                                    aria-labelledby="pills-{{ $language->name }}-edit-tab" tabindex="0">
                                    <label for="name" class="form-label">
                                        {{ __('Name (' . $language->name . ')') }} *
                                    </label>
                                    <input type="text" class="form-control" name="names[{{ $language->name }}]" :placeholder="'Enter Name (' . $language->name . ')'" id="editName_{{ $language->name }}" value="" />
                                </div>
                            @endforeach
                        </div>

                        <div class="mb-3 d-flex align-items-center gap-3">
                            <label for="updateColorCode" class="form-label m-0">
                                {{ __('Select Color') }}
                                <span class="text-danger">*</span>
                            </label>
                            <input type="color" id="updateColorCode" name="color_code"  style="width: 120px;height: 40px"/>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            {{ __('Close') }}
                        </button>
                        <button type="submit" class="btn btn-primary">
                            {{ __('Update') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>

@endsection
@push('css')
    <style>
        .nav-pills .nav-link {
            margin: 0 !important;
        }
    </style>
@endpush

@push('scripts')

<script>
    const openColorUpdateModal = (color, translations) => {

        $("#updateName").val(color.name);
        $("#updateColorCode").val(color.color_code);
        $("#updateColor").attr('action', `{{ route('admin.color.update', ':id') }}`.replace(':id', color.id));

        for (let i = 0; i < translations.length; i++) {
            if (translations[i].lang) {
                $("#editName_" + translations[i].lang).val(translations[i].name);
            }
        }

        $("#updateBrand").modal('show');
    }
</script>

@endpush
