<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Order Confirmation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .header {
            text-align: center;
            padding-bottom: 20px;
            border-bottom: 1px solid #ddd;
        }

        .header h1 {
            margin: 0;
            color: #333;
        }

        .content {
            padding: 20px 0;
            line-height: 1.6;
            color: #555;
        }

        .content p {
            margin: 0 0 10px;
        }

        .order-details {
            background: #f4f4f4;
            padding: 15px;
            border-radius: 8px;
        }

        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #999;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <h1>Order Confirmation</h1>
        </div>
        <div class="content">
            <p>Dear {{ $user->name }},</p>
            <p>Thank you for your order! We have received your request and are currently processing it.</p>

            <div class="order-details">
                <h3>Order Details</h3>
                <p><strong>Order Number:</strong> {{ $order->order_code }}</p>
                <p><strong>Date:</strong> {{ $order->created_at->format('d F, Y') }}</p>
                <p><strong>Total Amount:</strong> {{ showCurrency($order->payable_amount) }}</p>

                <h4>Items:</h4>
                <ul>
                    @foreach ($order->products as $product)
                        <li>{{ $product->name }} ({{ $product->pivot->quantity }})</li>
                    @endforeach
                </ul>
            </div>

            <p>If you have any questions or need further assistance, please don't hesitate to contact us.</p>
        </div>
        <div class="footer">
            <p>&copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
        </div>
    </div>
</body>

</html>
