@extends('layouts.app')
@section('content')
    <div class="container-fluid mt-3">

        <div class="card">
            <div class="card-header py-3">
                <h4 class="card-title m-0">
                    {{ __('Selected Product') }}
                </h4>
            </div>
            <div class="card-body">
                <div class="d-flex gap-3">
                    <div class="text-center">
                        <div class="rounded overflow-hidden ratio1x1">
                            <img src="{{ $product->thumbnail }}" alt="" width="140">
                        </div>
                    </div>

                    <div class="flex-grow-1">
                        <div class="d-flex flex-wrap gap-3 justify-content-between">
                            <div class="d-flex gap-3 productThumbnail">
                                @foreach ($product->thumbnails() as $photo)
                                    <img src="{{ $photo->thumbnail }}" alt="product" />
                                @endforeach
                            </div>

                            <div>
                                <div class="d-flex gap-3 border p-2 rounded fw-bold">
                                    <div>{{ $product->orders->count() }} {{ __('Orders') }}</div>

                                    <div class="border-start w-0" style="height: 20px"></div>

                                    <div>
                                        <i class="fa-solid fa-star text-warning"></i>
                                        {{ number_format($product->reviews->avg('rating'), 1) }}
                                    </div>

                                    <div class="border-start w-0" style="height: 20px"></div>

                                    <div>{{ number_format($product->reviews->count(), 1) }} {{ __('Reviews') }}</div>
                                </div>
                                <div class="mt-2">
                                    <div>
                                        {{ __('status') }}:
                                        @if ($product->is_approve)
                                            <span class="status-approved">
                                                <i class="fa fa-check text-success"></i>
                                                {{ __('Approved') }}
                                            </span>
                                        @else
                                            <span class="status-pending">
                                                <i class="fa-solid fa-triangle-exclamation"></i>
                                                {{ __('Pending') }}
                                            </span>
                                        @endif
                                    </div>
                                </div>

                            </div>

                        </div>
                        <h3 class="mb-2 mt-3 pb-1">{{ $product->name }}</h3>

                        <div>
                            <h6 class="mb-1 text-muted">
                                {{ __('Short Description') }}
                            </h6>
                            <p>{{ $product->short_description }}</p>
                        </div>
                    </div>
                </div>

                <div class="border-top my-3"></div>

                <!-- General Information -->
                <div class="d-flex gap-4 flex-wrap justify-content-lg-between">

                    <div>
                        <h5 class="text-dark fw-bold">{{ __('General Information') }}</h5>
                        <table class="table table-borderless mb-0 border-0">
                            <tr>
                                <td class="ps-0 py-1">
                                    {{ __('Brand') }}
                                </td>
                                <td class="py-1">: {{ $product->brand?->name }}</td>
                            </tr>
                            <tr>
                                <td class="ps-0 py-1">
                                    {{ __('Category') }}
                                </td>
                                <td class="py-1">
                                    : {{ $product->categories->implode('name', ', ') }}
                                </td>
                            </tr>
                        </table>
                    </div>

                    <div>
                        <h5 class="text-dark fw-bold">
                            {{ __('Price Information') }}
                        </h5>
                        <table class="table table-borderless mb-0 border-0">
                            <tr>
                                <td class="ps-0 py-1">Price</td>
                                <td class="py-1">: {{ showCurrency($product->price) }}</td>
                            </tr>
                            <tr>
                                <td class="ps-0 py-1">
                                    {{ __('Discount Price') }}
                                </td>
                                <td class="py-1">
                                    : {{ showCurrency($product->discount_price) }}
                                </td>
                            </tr>
                        </table>
                    </div>

                    <div>
                        <h5 class="text-dark fw-bold">
                            {{ __('Current Stock Quantity') }}
                        </h5>
                        <p class="mb-0 fw-bold">
                            {{ $product->quantity }}
                        </p>
                    </div>
                </div>

            </div>
        </div>

        <div class="d-flex align-items-center flex-wrap gap-3 justify-content-between mt-3">
            <h4 class="mb-0">
                {{ __('Recommended Products') }}
            </h4>
        </div>
        <div class="mb-3 mt-2 card">
            <div class="card-body">
                <form action="{{ route('shop.product.recommended.update', $product->id) }}" method="POST">
                    @csrf

                    <div class="table-responsive">
                        <table class="table border table-responsive-lg">
                            <thead>
                                <tr>
                                    <th class="text-center">{{ __('Check') }}</th>
                                    <th>{{ __('Thumbnail') }}</th>
                                    <th>{{ __('Product Name') }}</th>
                                    <th class="text-center">{{ __('Price') }}</th>
                                    <th class="text-center">{{ __('Discount Price') }}</th>
                                    <th class="text-center">
                                        {{ __('Verify Status') }}
                                    </th>
                                </tr>
                            </thead>
                            @forelse($products as $key => $product)
                                <tr onclick="selectedRow(this)" class="cursor-pointer">
                                    <td class="text-center">
                                        <input type="checkbox" class="form-check-input" name="ids[]"
                                            value="{{ $product->id }}" style="width: 20px; height: 20px"
                                            onclick="isChecked(this)" {{ in_array($product->id, $recommendedProducts) ? 'checked' : '' }}>
                                    </td>

                                    <td>
                                        <div class="product-image">
                                            <img src="{{ $product->thumbnail }}">
                                        </div>
                                    </td>

                                    <td>{{ Str::limit($product->name, 50, '...') }}</td>

                                    <td class="text-center">
                                        {{ showCurrency($product->price) }}
                                    </td>

                                    <td class="text-center">
                                        {{ showCurrency($product->discount_price) }}
                                    </td>

                                    <td class="text-center" style="min-width: 110px">
                                        @if ($product->is_approve)
                                            <span class="status-approved">
                                                <i class="fa fa-check-circle text-success"></i> {{ __('Approved') }}
                                            </span>
                                        @else
                                            <span class="status-pending" data-bs-toggle="tooltip" data-bs-placement="top"
                                                data-bs-title="Your product status is pending because admin hasn't approved it. When admin will approve your product, it will be show as approved.">
                                                <i class="fa-solid fa-triangle-exclamation"></i>
                                                {{ __('Pending') }}
                                            </span>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-center" colspan="100%">{{ __('No Data Found') }}</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="">
                        <div class="d-flex justify-content-end">
                            <small>{{ __('Select at least one recommended product') }}</small>
                        </div>
                        <div class="d-flex justify-content-end gap-3 mt-2">
                            <a href="{{ route('shop.product.index') }}" class="btn btn-light px-4 py-2.5">
                                {{ __('Back') }}
                            </a>
                            <button type="submit" class="btn btn-primary px-4 py-2.5">
                                {{ __('Submit') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

    </div>
@endsection
@push('scripts')
    <script>
        function selectedRow(row) {
            const input = $(row).find("input[name='ids[]']");
            if (input.is(":checked")) {
                input.prop("checked", false);
            } else {
                input.prop("checked", true);
            }
        }

        function isChecked(input) {
            if (input.checked) {
                input.checked = false;
            } else {
                input.checked = true;
            }
        }
    </script>
@endpush
