<!--- Dashboard --->
<li>
    <a class="menu <?php echo e($request->routeIs('admin.dashboard.*') ? 'active' : ''); ?>"
        href="<?php echo e(route('admin.dashboard.index')); ?>">
        <span>
            <i class="fa-solid fa-house menu-icon"></i>
            <?php echo e(__('Dashboard')); ?>

        </span>
    </a>
</li>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.banner.index', 'admin.ad.index', 'admin.coupon.index', 'admin.customerNotification.index'])): ?>
    <li class="menu-divider">
        <span class="menu-title"><?php echo e(__('Marketing Promotions')); ?></span>
    </li>
<?php endif; ?>
<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.banner.index')): ?>
    <!--- banner--->
    <li>
        <a class="menu <?php echo e($request->routeIs('admin.banner.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.banner.index')); ?>">
            <span>
                <i class="fa-solid fa-image menu-icon"></i>
                <?php echo e(__('Promotional Banner')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.ad.index')): ?>
    <!--- ads--->
    <li>
        <a class="menu <?php echo e($request->routeIs('admin.ad.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.ad.index')); ?>">
            <span>
                <i class="fa-solid fa-photo-film menu-icon"></i>
                <?php echo e(__('Ads')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.coupon.index')): ?>
    <!--- Coupon discount--->
    <li>
        <a class="menu <?php echo e($request->routeIs('admin.coupon.*') ? 'active' : ''); ?>"
            href="<?php echo e(route('admin.coupon.index')); ?>">
            <span>
                <i class="fa-solid fa-ticket menu-icon"></i>
                <?php echo e(__('Promo Code')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.customerNotification.index')): ?>
    <!--- notification--->
    <li>
        <a class="menu <?php echo e($request->routeIs('admin.customerNotification.*') ? 'active' : ''); ?>"
            href="<?php echo e(route('admin.customerNotification.index')); ?>">
            <span>
                <i class="fa-solid fa-bell menu-icon"></i>
                <?php echo e(__('Send Notifications')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php
    use App\Enums\OrderStatus;
    $orderStatuses = OrderStatus::cases();
?>
<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.order.index')): ?>
    <li class="menu-divider">
        <span class="menu-title"><?php echo e(__('Order Handling')); ?></span>
    </li>

    <!--- Orders --->
    <li>
        <a class="menu <?php echo e(request()->routeIs('admin.order.*') ? 'active' : ''); ?>" data-bs-toggle="collapse"
            href="#ordersMenu">
            <span>
                <i class="fa-solid fa-cart-shopping menu-icon"></i>
                <?php echo e(__('All Orders')); ?>

            </span>
            <img src="<?php echo e(asset('assets/icons/arrowDown.svg')); ?>" alt="" class="downIcon">
        </a>
        <div class="collapse dropdownMenuCollapse <?php echo e($request->routeIs('admin.order.*') ? 'show' : ''); ?>" id="ordersMenu">
            <div class="listBar">
                <a href="<?php echo e(route('admin.order.index')); ?>"
                    class="subMenu hasCount <?php echo e(request()->url() === route('admin.order.index') ? 'active' : ''); ?>">
                    <?php echo e(__('All')); ?> <span class="count statusAll"><?php echo e($allOrders > 99 ? '99+' : $allOrders); ?></span>
                </a>
                <?php $__currentLoopData = $orderStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('admin.order.index', str_replace(' ', '_', $status->value))); ?>"
                        class="subMenu hasCount <?php echo e(request()->url() === route('admin.order.index', str_replace(' ', '_', $status->value)) ? 'active' : ''); ?>">
                        <span><?php echo e(__($status->value)); ?></span>
                        <span
                            class="count status<?php echo e(Str::camel($status->value)); ?>"><?php echo e(${Str::camel($status->value)} > 99 ? '99+' : ${Str::camel($status->value)}); ?></span>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.brand.index', 'admin.color.index', 'admin.size.index', 'admin.unit.index'])): ?>
    <li class="menu-divider">
        <span class="menu-title"><?php echo e(__('Product Variants')); ?></span>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.brand.index')): ?>
    <!--- brand --->
    <li>
        <a class="menu <?php echo e($request->routeIs('admin.brand.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.brand.index')); ?>">
            <span>
                <i class="fa-solid fa-star menu-icon"></i>
                <?php echo e(__('Brand')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.color.index')): ?>
    <!--- color--->
    <li>
        <a class="menu <?php echo e($request->routeIs('admin.color.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.color.index')); ?>">
            <span>
                <i class="fa-solid fa-palette menu-icon"></i>
                <?php echo e(__('Color')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.size.index')): ?>
    <!--- size--->
    <li>
        <a class="menu <?php echo e($request->routeIs('admin.size.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.size.index')); ?>">
            <span>
                <i class="fa-solid fa-list-ol menu-icon"></i>
                <?php echo e(__('Sizes')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.unit.index')): ?>
    <!--- unit--->
    <li>
        <a class="menu <?php echo e($request->routeIs('admin.unit.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.unit.index')); ?>">
            <span>
                <i class="fa-brands fa-unity menu-icon"></i>
                <?php echo e(__('Unit')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.category.index', 'admin.subcategory.index', 'admin.product.index', 'admin.gift.index'])): ?>
    <li class="menu-divider">
        <span class="menu-title"><?php echo e(__('Product Management')); ?></span>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.category.index', 'admin.subcategory.index'])): ?>
    <!--- categories--->
    <li>
        <a class="menu <?php echo e(request()->routeIs('admin.category.*', 'admin.subcategory.*') ? 'active' : ''); ?>"
            data-bs-toggle="collapse" href="#categoryMenu">
            <span>
                <i class="fa-solid fa-border-all menu-icon"></i>
                <?php echo e(__('Categories')); ?>

            </span>
            <img src="<?php echo e(asset('assets/icons/arrowDown.svg')); ?>" alt="" class="downIcon">
        </a>
        <div class="collapse dropdownMenuCollapse <?php echo e($request->routeIs('admin.category.*', 'admin.subcategory.*') ? 'show' : ''); ?>"
            id="categoryMenu">
            <div class="listBar">
                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.category.index')): ?>
                    <a href="<?php echo e(route('admin.category.index')); ?>"
                        class="subMenu hasCount <?php echo e(request()->routeIs('admin.category.*') ? 'active' : ''); ?>">
                        <?php echo e(__('Category')); ?>

                    </a>
                <?php endif; ?>
                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.subcategory.index')): ?>
                    <!--- sub categories--->
                    <a href="<?php echo e(route('admin.subcategory.index')); ?>"
                        class="subMenu hasCount <?php echo e(request()->routeIs('admin.subcategory.*') ? 'active' : ''); ?>">
                        <?php echo e(__('Sub Category')); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.product.index')): ?>
    <!--- Products--->
    <li>
        <a class="menu <?php echo e($request->routeIs('shop.product.*') ? 'active' : ''); ?>"
            href="<?php echo e(route('shop.product.index')); ?>">
            <span>
                <i class="fa-brands fa-codepen menu-icon"></i>
                <?php echo e(__('Products')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['shop.pos.index', 'shop.pos.draft', 'shop.pos.sales'])): ?>
    <li class="menu-divider">
        <span class="menu-title"><?php echo e(__('POS Management')); ?></span>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.pos.index')): ?>
    <!--- POS--->
    <li>
        <a class="menu <?php echo e($request->routeIs('shop.pos.index') ? 'active' : ''); ?>" href="<?php echo e(route('shop.pos.index')); ?>">
            <span>
                <i class="fa-solid fa-store menu-icon"></i>
                <?php echo e(__('POS')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.pos.draft')): ?>
    <!--- Draft --->
    <li>
        <a class="menu <?php echo e($request->routeIs('shop.pos.draft') ? 'active' : ''); ?>" href="<?php echo e(route('shop.pos.draft')); ?>">
            <span>
                <i class="fa-brands fa-firstdraft menu-icon"></i>
                <?php echo e(__('Draft')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.pos.sales')): ?>
    <!--- POS Sales--->
    <li>
        <a class="menu <?php echo e($request->routeIs('shop.pos.sales') ? 'active' : ''); ?>" href="<?php echo e(route('shop.pos.sales')); ?>">
            <span>
                <i class="fa-solid fa-cart-shopping menu-icon"></i>
                <?php echo e(__('POS Sales')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if($businessModel == 'multi'): ?>
    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.shop.index', 'admin.product.index'])): ?>
        <li class="menu-divider">
            <span class="menu-title"><?php echo e(__('Manage Shop')); ?></span>
        </li>
    <?php endif; ?>

    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.shop.index')): ?>
        <!--- shops --->
        <li>
            <a href="<?php echo e(route('admin.shop.index')); ?>"
                class="menu <?php echo e(request()->routeIs('admin.shop.*') ? 'active' : ''); ?>">
                <span>
                    <i class="fa-solid fa-shop menu-icon"></i>
                    <?php echo e(__('All Shops')); ?>

                </span>
            </a>
        </li>
    <?php endif; ?>

    <!--- admin Shop products --->
    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.product.index'])): ?>
        <li>
            <a class="menu <?php echo e(request()->routeIs('admin.product.index') ? 'active' : ''); ?>" data-bs-toggle="collapse"
                href="#shopProducts">
                <span>
                    <i class="fa-solid fa-basket-shopping menu-icon"></i>
                    <?php echo e(__('Shop Products')); ?>

                </span>
                <img src="<?php echo e(asset('assets/icons/arrowDown.svg')); ?>" alt="" class="downIcon">
            </a>
            <div class="collapse dropdownMenuCollapse <?php echo e($request->routeIs('admin.product.index') ? 'show' : ''); ?>"
                id="shopProducts">
                <div class="listBar">
                    <?php if($generaleSetting?->new_product_approval): ?>
                        <a href="<?php echo e(route('admin.product.index', 'status=0')); ?>"
                            class="subMenu <?php echo e(request()->filled('status') && request()->status == 0 ? 'active' : ''); ?>"
                            title="<?php echo e(__('Item Request')); ?>">
                            <?php echo e(__('Item Request')); ?>

                        </a>
                    <?php endif; ?>

                    <?php if($generaleSetting?->update_product_approval): ?>
                        <a href="<?php echo e(route('admin.product.index', 'status=1')); ?>"
                            class="subMenu <?php echo e(request()->filled('status') && request()->status == 1 ? 'active' : ''); ?>"
                            title="<?php echo e(__('Update Request')); ?>">
                            <?php echo e(__('Update Request')); ?>

                        </a>
                    <?php endif; ?>

                    <a href="<?php echo e(route('admin.product.index', 'approve=true')); ?>"
                        class="subMenu <?php echo e(request()->filled('approve') && request()->approve == 'true' ? 'active' : ''); ?>"
                        title="<?php echo e(__('Accepted Item')); ?>">
                        <?php echo e(__('Accepted Item')); ?>

                    </a>
                </div>
            </div>
        </li>
    <?php endif; ?>

    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.flashSale.index')): ?>
        <li>
            <a href="<?php echo e(route('admin.flashSale.index')); ?>"
                class="menu <?php echo e(request()->routeIs('admin.flashSale.*') ? 'active' : ''); ?>">
                <span>
                    <i class="fa-solid fa-bolt menu-icon"></i>
                    <?php echo e(__('Flash Sales')); ?>

                </span>
            </a>
        </li>
    <?php endif; ?>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.rider.index', 'admin.customer.index', 'admin.employee.index', 'admin.role.index'])): ?>
    <li class="menu-divider">
        <span class="menu-title"><?php echo e(__('User Supervision')); ?></span>
    </li>
<?php endif; ?>



<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.customer.index'])): ?>
    <!--- customers --->
    <li>
        <a class="menu <?php echo e($request->routeIs('admin.customer.*') ? 'active' : ''); ?>"
            href="<?php echo e(route('admin.customer.index')); ?>">
            <span>
                <i class="fa-solid fa-user menu-icon"></i>
                <?php echo e(__('Customers')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.employee.index'])): ?>
    <!--- employee --->
    <li>
        <a class="menu <?php echo e($request->routeIs('admin.employee.*') ? 'active' : ''); ?>"
            href="<?php echo e(route('admin.employee.index')); ?>">
            <span>
                <i class="fa-solid fa-users-gear menu-icon"></i>
                <?php echo e(__('Employees')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.role.index'])): ?>
    <!--- roles and permissions --->
    <li>
        <a class="menu <?php echo e($request->routeIs('admin.role.*') ? 'active' : ''); ?>"
            href="<?php echo e(route('admin.role.index')); ?>">
            <span>
                <i class="fa-solid fa-key menu-icon"></i>
                <?php echo e(__('Roles & Permissions')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', [
    'admin.generale-setting.index',
    'admin.business-setting.index',
    'admin.socialLink.index',
    'admin.themeColor.index',
    'admin.deliveryCharge.index',
    'admin.ticketissuetype.index',
    'admin.legalpage.index',
    'admin.contactUs.index',
    'admin.pusher.index',
    'admin.mailConfig.index',
    'admin.paymentGateway.index',
    'admin.sms-gateway.index',
    'admin.firebase.index',
    'admin.verification.index'
])): ?>
    <li class="menu-divider">
        <span class="menu-title"><?php echo e(__('Business Administration')); ?></span>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.generale-setting.index', 'admin.business-setting.index', 'admin.socialLink.index', 'admin.themeColor.index', 'admin.deliveryCharge.index', 'admin.ticketissuetype.index', 'admin.verification.index', 'admin.vatTax.index'])): ?>
    <!--- Settings --->
    <li>
        <a class="menu <?php echo e(request()->routeIs('admin.generale-setting.*', 'admin.business-setting.*', 'admin.socialLink.*', 'admin.themeColor.*', 'admin.deliveryCharge.*', 'admin.ticketissuetype.*', 'admin.verification.*', 'admin.vatTax.*') ? 'active' : ''); ?>"
            data-bs-toggle="collapse" href="#settings">
            <span>
                <i class="bi bi-gear-fill menu-icon"></i>
                <?php echo e(__('Buisness Settings')); ?>

            </span>
            <img src="<?php echo e(asset('assets/icons/arrowDown.svg')); ?>" alt="" class="downIcon">
        </a>
        <div class="collapse dropdownMenuCollapse <?php echo e($request->routeIs('admin.generale-setting.*', 'admin.business-setting.*', 'admin.socialLink.*', 'admin.themeColor.*', 'admin.deliveryCharge.*', 'admin.ticketissuetype.*', 'admin.verification.*', 'admin.vatTax.*', 'admin.currency.*') ? 'show' : ''); ?>"
            id="settings">
            <div class="listBar">
                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.generale-setting.index')): ?>
                    <a href="<?php echo e(route('admin.generale-setting.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.generale-setting.index') ? 'active' : ''); ?>">
                        <?php echo e(__('General Settings')); ?>

                    </a>
                <?php endif; ?>

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.business-setting.index')): ?>
                    <a href="<?php echo e(route('admin.business-setting.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.business-setting.*') ? 'active' : ''); ?>">
                        <?php echo e(__('Business Setup')); ?>

                    </a>
                <?php endif; ?>

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.currency.index')): ?>
                    <a href="<?php echo e(route('admin.currency.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.currency.index') ? 'active' : ''); ?>">
                        <?php echo e(__('Currency')); ?>

                    </a>
                <?php endif; ?>

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.verification.index')): ?>
                    <a href="<?php echo e(route('admin.verification.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.verification.*') ? 'active' : ''); ?>">
                        <?php echo e(__('OTP Verification')); ?>

                    </a>
                <?php endif; ?>

                

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.vatTax.index')): ?>
                    <a href="<?php echo e(route('admin.vatTax.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.vatTax.*') ? 'active' : ''); ?>">
                        <?php echo e(__('VAT & Tax')); ?>

                    </a>
                <?php endif; ?>

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.themeColor.index')): ?>
                    <a href="<?php echo e(route('admin.themeColor.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.themeColor.*') ? 'active' : ''); ?>">
                        <?php echo e(__('Theme Colors')); ?>

                    </a>
                <?php endif; ?>

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.socialLink.index')): ?>
                    <a href="<?php echo e(route('admin.socialLink.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.socialLink.index') ? 'active' : ''); ?>">
                        <?php echo e(__('Social Links')); ?>

                    </a>
                <?php endif; ?>

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.ticketissuetype.index')): ?>
                    <a href="<?php echo e(route('admin.ticketissuetype.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.ticketissuetype.index') ? 'active' : ''); ?>">
                        <?php echo e(__('Ticket Issue Types')); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>
    </li>
<?php endif; ?>

<?php use \App\Models\LegalPage; ?>
<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.legalpage.index', 'admin.contactUs.index'])): ?>
    <!--- legal pages --->
    <li>
        <a class="menu <?php echo e(request()->routeIs('admin.legalpage.*', 'admin.contactUs.*') ? 'active' : ''); ?>"
            data-bs-toggle="collapse" href="#legalPages">
            <span>
                <i class="fa-solid fa-bookmark menu-icon"></i>
                <?php echo e(__('Legal Pages')); ?>

            </span>
            <img src="<?php echo e(asset('assets/icons/arrowDown.svg')); ?>" alt="" class="downIcon">
        </a>
        <div class="collapse dropdownMenuCollapse <?php echo e($request->routeIs('admin.legalpage.*', 'admin.contactUs.*') ? 'show' : ''); ?>" id="legalPages">
            <div class="listBar">
                <?php $__currentLoopData = LegalPage::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $legalPage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('admin.legalpage.index', $legalPage->slug)); ?>"
                        class="subMenu <?php echo e(request()->fullUrl() === route('admin.legalpage.edit', $legalPage->slug) || request()->fullUrl() === route('admin.legalpage.index', $legalPage->slug) ? 'active' : ''); ?>"
                        title="<?php echo e($legalPage->title); ?>">
                        <?php echo e(__($legalPage->title)); ?>

                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.contactUs.index')): ?>
                    <a href="<?php echo e(route('admin.contactUs.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.contactUs.*') ? 'active' : ''); ?>">
                        <?php echo e(__('Contact Us')); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.pusher.index', 'admin.mailConfig.index', 'admin.paymentGateway.index', 'admin.sms-gateway.index', 'admin.firebase.index', 'admin.googleReCaptcha.index'])): ?>
    <li>
        <a class="menu <?php echo e(request()->routeIs('admin.pusher.*', 'admin.mailConfig.*', 'admin.paymentGateway.*', 'admin.sms-gateway.*', 'admin.firebase.*'), 'admin.googleReCaptcha.*' ? 'active' : ''); ?>"
            data-bs-toggle="collapse" href="#thirdpartConfig" title="Third Party configuration">
            <span>
                <i class="bi bi-boxes menu-icon"></i>
                <?php echo e(__('3rd Party Configaration')); ?>

            </span>
            <img src="<?php echo e(asset('assets/icons/arrowDown.svg')); ?>" alt="" class="downIcon">
        </a>
        <div class="collapse dropdownMenuCollapse <?php echo e($request->routeIs('admin.pusher.*', 'admin.mailConfig.*', 'admin.paymentGateway.*', 'admin.sms-gateway.*', 'admin.firebase.*', 'admin.googleReCaptcha.*') ? 'show' : ''); ?>"
            id="thirdpartConfig">
            <div class="listBar">
                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.paymentGateway.index')): ?>
                    <a href="<?php echo e(route('admin.paymentGateway.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.paymentGateway.*') ? 'active' : ''); ?>">
                        <?php echo e(__('Payment Gateway')); ?>

                    </a>
                <?php endif; ?>

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.sms-gateway.index')): ?>
                    <a href="<?php echo e(route('admin.sms-gateway.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.sms-gateway.*') ? 'active' : ''); ?>">
                        <?php echo e(__('SMS Gateway')); ?>

                    </a>
                <?php endif; ?>

                

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.pusher.index')): ?>
                    <a href="<?php echo e(route('admin.pusher.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.pusher.*') ? 'active' : ''); ?>">
                        <?php echo e(__('Pusher Setup')); ?>

                    </a>
                <?php endif; ?>

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.mailConfig.index')): ?>
                    <a href="<?php echo e(route('admin.mailConfig.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.mailConfig.*') ? 'active' : ''); ?>">
                        <?php echo e(__('Mail Config')); ?>

                    </a>
                <?php endif; ?>

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.firebase.index')): ?>
                    <a href="<?php echo e(route('admin.firebase.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.firebase.*') ? 'active' : ''); ?>">
                        <?php echo e(__('Firebase Notification')); ?>

                    </a>
                <?php endif; ?>

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.googleReCaptcha.index')): ?>
                    <a href="<?php echo e(route('admin.googleReCaptcha.index')); ?>"
                        class="subMenu <?php echo e(request()->routeIs('admin.googleReCaptcha.*') ? 'active' : ''); ?>">
                        <?php echo e(__('Google ReCaptcha')); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>
    </li>
<?php endif; ?>

<li>
    <a class="menu <?php echo e($request->routeIs('admin.country.*') ? 'active' : ''); ?>"
        href="<?php echo e(route('admin.country.index')); ?>">
        <span>
            <i class="fa-solid fa-globe menu-icon"></i>
            <?php echo e(__('Countries')); ?>

        </span>
    </a>
</li>

<li>
    <a class="menu <?php echo e($request->routeIs('admin.city.*') ? 'active' : ''); ?>"
        href="<?php echo e(route('admin.city.index')); ?>">
        <span>
            <i class="fa-solid fa-globe menu-icon"></i>
            <?php echo e(__('Cities')); ?>

        </span>
    </a>
</li>

<?php if($businessModel == 'multi'): ?>
    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.withdraw.index'])): ?>
        <li class="menu-divider">
            <span class="menu-title"><?php echo e(__('Accounts')); ?></span>
        </li>
        <!--- withdraw --->
        <li>
            <a class="menu <?php echo e($request->routeIs('admin.withdraw.*') ? 'active' : ''); ?>"
                href="<?php echo e(route('admin.withdraw.index')); ?>">
                <span>
                    <i class="bi bi-wallet2 menu-icon"></i>
                    <?php echo e(__('Withdraws')); ?>

                </span>
            </a>
        </li>
    <?php endif; ?>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.language.index'])): ?>
    <li class="menu-divider">
        <span class="menu-title"><?php echo e(__('Language Settings')); ?></span>
    </li>
    <!--- Languages --->
    <li>
        <a href="<?php echo e(route('admin.language.index')); ?>"
            class="menu <?php echo e(request()->routeIs('admin.language.*') ? 'active' : ''); ?>">
            <span>
                <i class="fa-solid fa-language menu-icon"></i>
                <?php echo e(__('Languages')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if($businessModel != 'single'): ?>
    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['shop.profile.index'])): ?>
        <li class="menu-divider">
            <span class="menu-title"><?php echo e(__('STORE MANAGEMENT')); ?></span>
        </li>
        <!--- Profile --->
        <li>
            <a class="menu <?php echo e($request->routeIs('shop.profile.*') ? 'active' : ''); ?>"
                href="<?php echo e(route('shop.profile.index')); ?>">
                <span>
                    <i class="bi bi-person-circle menu-icon"></i>
                    <?php echo e(__('Shop Profile')); ?>

                </span>
            </a>
        </li>
    <?php endif; ?>
<?php endif; ?>

<!--- Import / Export --->
<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['shop.bulk-product-import.index', 'shop.bulk-product-export.index', 'shop.gallery.index'])): ?>
    <li class="menu-divider">
        <span class="menu-title"><?php echo e(__('Import / Export')); ?></span>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.bulk-product-export.index')): ?>
    <li>
        <a class="menu <?php echo e($request->routeIs('shop.bulk-product-export.*') ? 'active' : ''); ?>"
            href="<?php echo e(route('shop.bulk-product-export.index')); ?>">
            <span>
                <i class="fa-solid fa-download menu-icon"></i>
                <?php echo e(__('Bulk Export')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.bulk-product-import.index')): ?>
    <li>
        <a class="menu <?php echo e($request->routeIs('shop.bulk-product-import.*') ? 'active' : ''); ?>"
            href="<?php echo e(route('shop.bulk-product-import.index')); ?>">
            <span>
                <i class="fa-solid fa-upload menu-icon"></i>
                <?php echo e(__('Bulk Import')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.gallery.index')): ?>
    <!--- gallery --->
    <li>
        <a class="menu <?php echo e($request->routeIs('shop.gallery.*') ? 'active' : ''); ?>"
            href="<?php echo e(route('shop.gallery.index')); ?>">
            <span>
                <i class="fa-solid fa-file-image menu-icon"></i>
                <?php echo e(__('Gallery Import')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.supportTicket.index', 'admin.support.index'])): ?>
    <li class="menu-divider">
        <span class="menu-title"><?php echo e(__('Assistance/ Support')); ?></span>
    </li>
<?php endif; ?>
<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.supportTicket.index'])): ?>
    <!--- Help Requests --->
    <li>
        <a href="<?php echo e(route('admin.supportTicket.index')); ?>"
            class="menu <?php echo e(request()->routeIs('admin.supportTicket.*') ? 'active' : ''); ?>">
            <span>
                <i class="bi bi-ticket-perforated menu-icon"></i>
                <?php echo e(__('Help Requests')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.support.index'])): ?>
    <!--- Help Notes --->
    <li>
        <a href="<?php echo e(route('admin.support.index')); ?>"
            class="menu <?php echo e(request()->routeIs('admin.support.*') ? 'active' : ''); ?>">
            <span>
                <i class="bi bi-chat-right-text menu-icon"></i>
                <?php echo e(__('Help Notes')); ?>

            </span>
        </a>
    </li>
<?php endif; ?>
<?php /**PATH /Users/abedin.dev/Code/maya-mart/resources/views/layouts/partials/admin-menu.blade.php ENDPATH**/ ?>