<?php
    $directory = app()->getLocale() == 'ar' ? 'rtl' : 'ltr';
?>
<!DOCTYPE html>
<html lang="en" dir="<?php echo e($directory); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- App favicon -->
    <link rel="shortcut icon" type="image/png" href="<?php echo e($generaleSetting?->favicon ?? asset('assets/favicon.png')); ?>" />

    <!-- App title -->
    <title><?php echo e($generaleSetting?->title ?? config('app.name', 'Laravel')); ?></title>

    <!-- Meta -->
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="all,follow">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Google fonts - Inter -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">

    <!-- Font-Awesome--Min-Css-Link -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/font-awesome.min.css')); ?>">

    <!-- sweetalert css-->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/sweetalert2.min.css')); ?>">

    <!-- table sorter stylesheet-->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/datatables.min.css')); ?>">

    <!-- Bootstrap--Min-Css-Link -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">

    <!-- Select2 -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/select2.min.css')); ?>">

    <!-- quill css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/quill.snow.css')); ?>">

    <!-- Custom--Css-Link -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">

    <!-- Apexcharts Link -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/apexcharts.css')); ?>">

    <!--Responsive--Css-Link -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/responsive.css')); ?>">

    <!-- Toastr Css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/toastr.min.css')); ?>">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <link rel="stylesheet" href="<?php echo e(asset('assets/css/jquery.timepicker.min.css')); ?>" type="text/css" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/jquery-ui.css')); ?>" type="text/css">

    <?php echo $__env->yieldPushContent('css'); ?>

    <style>
        .has-passport.fixed-header .app-header {
            top: 55px;
        }

        .has-passport.fixed-sidebar .app-main .app-main-outer {
            padding-top: 50px;
        }

        .has-passport.fixed-sidebar .app-sidebar {
            top: 80px;
            height: 100svh;
        }
    </style>
</head>

<body>
    <!-- alert for seeder and passport install and storage link -->
    <div class="w-100 d-flex flex-column gap-1" style="z-index: 99; position: fixed; top: 0;">
        <!-- seeder run -->
        <?php if($seederRun): ?>
            <div class="alert alert-danger alert-dismissible fade show mb-0 w-100 text-center rounded-0 text-black"
                role="alert" style="padding: 10px">
                <strong><i class="fa fa-exclamation-circle" data-toggle="tooltip" data-placement="bottom"
                        title='If you do not run this seeder, you will not be able to use the system.'></i>
                    Seeder dose not run.</strong> Please run <code class="text-danger">php artisan migrate:fresh
                    --seed</code> or <a href="<?php echo e(route('seeder.run.index')); ?>" class="btn btn-sm common-btn"> Click
                    here</a>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"
                    id="closeAlert"></button>
            </div>
        <?php endif; ?>

        <!-- storage link -->
        <?php if($storageLink): ?>
            <div class="alert alert-danger alert-dismissible fade show mb-0 w-100 text-center rounded-0 text-black"
                role="alert" style="padding: 10px">
                <strong><i class="fa fa-exclamation-circle" data-toggle="tooltip" data-placement="bottom"
                        title='If you can not install storage link, then image not found.'></i>
                    Storage link dose not exist or image not found then</strong> please run <code
                    class="text-danger">php artisan
                    storage:link</code> or <a href="<?php echo e(route('storage.install.index')); ?>"
                    class="btn btn-sm common-btn">
                    Click here</a>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"
                    id="closeAlert"></button>
            </div>
        <?php endif; ?>
    </div>

    <div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header <?php echo e($seederRun || $storageLink ? 'has-passport' : ''); ?>"
        id="appContent">
        <div class="app-header header-shadow">
            <div class="app-header-logo"></div>
            <div class="app-header-mobile-menu">
                <div>
                    <button type="button" class="hamburger hamburger--elastic mobile-toggle-nav">
                        <span class="hamburger-box">
                            <span class="hamburger-inner"></span>
                        </span>
                    </button>
                </div>
            </div>
            <div class="app-header-menu">
                <span>
                    <button type="button"
                        class="btn-icon btn-icon-only btn btn-primary btn-sm mobile-toggle-header-nav">
                        <span class="btn-icon-wrapper">
                            <i class="fa fa-ellipsis-v fa-w-6"></i>
                        </span>
                    </button>
                </span>
            </div>
            <div class="app-header-content">
                <!-- Header-left-Section -->
                <div class="app-header-left">
                    <div class="header-pane ">
                        <div>
                            <button type="button" class="hamburger close-sidebar-btn hamburger--elastic"
                                data-class="closed-sidebar">
                                <span class="hamburger-box">
                                    <span class="hamburger-inner"></span>
                                </span>
                            </button>
                        </div>
                    </div>
                </div>
                <!-- End-Header-Left-section -->

                <!-- Header-Rignt-Section -->
                <div class="app-header-right">

                    <?php if($businessModel == 'multi'): ?>
                        <?php
                            $user = auth()->user();
                            $isShop = true;
                            if (!$user->hasRole('root') && ($user->shop || $user->myShop)) {
                                $isShop = false;
                            }
                        ?>

                    <?php endif; ?>

                    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.dashboard.notification', 'shop.dashboard.notification'])): ?>
                        <!-- Notification Section -->
                        <div class="badgeButtonBox me-3">
                            <div class="notifactionIcon">
                                <button type="button" class="emailBadge dropdown-toggle position-relative"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fa-solid fa-bell noti"></i>
                                    <span class="position-absolute notificationCount" id="totalNotify"></span>
                                </button>
                                <div class="dropdown-menu p-0 emailNotifactionSection">
                                    <div class="dropdown-item emailNotifaction">
                                        <div class="emailHeader">
                                            <h6 class="massTitel">
                                                <?php echo e(__('Notifications')); ?>

                                            </h6>
                                            <a href="<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.dashboard.notification')): ?>
                                                <?php echo e(route('admin.notification.readAll')); ?>

                                                <?php else: ?>
                                                <?php echo e(route('shop.notification.readAll')); ?>

                                                <?php endif; ?>"
                                                class="text-dark">
                                                <?php echo e(__('Marks all as read')); ?>

                                            </a>
                                        </div>
                                        <div class="messege-section" id="notifications">

                                        </div>
                                        <div class="emailFooter">
                                            <a href="<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.dashboard.notification')): ?>
                                                <?php echo e(route('admin.notification.show')); ?>

                                                <?php else: ?>
                                                <?php echo e(route('shop.notification.show')); ?>

                                                <?php endif; ?>"
                                                class="massPera text-dark">
                                                <?php echo e(__('View All Notifications')); ?>

                                            </a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Language Dropdown -->
                    <div class="user-profile-box dropdown mx-3">
                        <div class="nav-profile-box dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                            <div class="profile-image">
                                <a href="#">
                                    <img class="" src="<?php echo e(asset('assets/icons/language.svg')); ?>"
                                        alt="" />
                                </a>
                            </div>
                        </div>
                        <div class="dropdown-menu profile-item" style="width: 160px !important">
                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('change.language', 'language=' . $lang->name)); ?>"
                                    class="dropdown-item <?php echo e($lang->name == app()->getLocale() ? 'language-active' : ''); ?>">
                                    <i class="fa fa-language mr-3"></i>
                                    <?php echo e(__($lang->title)); ?>

                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="user-profile-box dropdown ml-3">
                        <div class="nav-profile-box dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                            <div class="profile-image">
                                <img class="profilepic"
                                    src="<?php echo e(auth()->user()->thumbnail ?? asset('assets/icons/user.svg')); ?>"
                                    alt="profile" loading="lazy" />
                            </div>
                            <div class="profile-content">
                                <span><?php echo e(ucfirst(auth()->user()->name)); ?></span>
                                <i class="fa-solid fa-angle-down dropIcon"></i>
                            </div>
                        </div>

                        <div class="dropdown-menu profile-item ">
                            <?php if(request()->is('admin/*', 'admin')): ?>
                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.profile.index')): ?>
                                    <a href="<?php echo e(route('admin.profile.index')); ?>" class="dropdown-item">
                                        <i class="fa fa-user <?php echo e($directory == 'rtl' ? 'ms-2' : 'me-2'); ?>"></i>
                                        <?php echo e(__('Profile')); ?>

                                    </a>
                                <?php endif; ?>
                            <?php else: ?>
                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.profile.index')): ?>
                                    <a href="<?php echo e(route('shop.profile.index')); ?>" class="dropdown-item">
                                        <i class="fa fa-user <?php echo e($directory == 'rtl' ? 'ms-2' : 'me-2'); ?>"></i>
                                        <?php echo e(__('Profile')); ?>

                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if(request()->is('admin/*', 'admin')): ?>
                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.generale-setting.index')): ?>
                                    <a href="<?php echo e(route('admin.generale-setting.index')); ?>" class="dropdown-item">
                                        <i
                                            class="fa fa-cog <?php echo e($directory == 'rtl' ? 'ms-2' : 'me-2'); ?>"></i><?php echo e(__('Settings')); ?>

                                    </a>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.profile.change-password')): ?>
                                    <a href="<?php echo e(route('admin.profile.change-password')); ?>" class="dropdown-item">
                                        <i
                                            class="fa-solid fa-key <?php echo e($directory == 'rtl' ? 'ms-2' : 'me-2'); ?>"></i><?php echo e(__('Change Password')); ?>

                                    </a>
                                <?php endif; ?>
                            <?php else: ?>
                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.profile.change-password')): ?>
                                    <a href="<?php echo e(route('shop.profile.change-password')); ?>" class="dropdown-item">
                                        <i
                                            class="fa-solid fa-key <?php echo e($directory == 'rtl' ? 'ms-2' : 'me-2'); ?>"></i><?php echo e(__('Change Password')); ?>

                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>

                            <button class="dropdown-item cursor-pointer logout">
                                <i
                                    class="fa-solid fa-right-from-bracket <?php echo e($directory == 'rtl' ? 'ms-2' : 'me-2'); ?>"></i>
                                <?php echo e(__('Logout')); ?>

                            </button>
                        </div>
                    </div>
                </div>
                <!-- End-Header-Right-Section -->

            </div>
        </div>
        <div class="app-main">

            <?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- ****Body-Section***** -->

            <div class="app-main-outer">
                <!-- ****End-Body-Section**** -->
                <div class="app-main-inner">
                    <div class="container-fluid">

                        <?php echo $__env->yieldContent('content'); ?>

                    </div>
                </div>
                <!-- Footer-Section -->

                <?php if(!$generaleSetting || $generaleSetting?->show_footer): ?>
                    <div class="app-wrapper-footer">
                        <div class="app-footer">
                            <div class="app-footer-inner">
                                <div>
                                    © <?php echo e(date('Y')); ?> <?php echo e($generaleSetting?->footer_text); ?>

                                </div>
                                <div class="d-none d-sm-block">
                                    <i class="bi bi-telephone"></i>
                                    <span>
                                        <?php echo e($generaleSetting?->footer_phone ?? '+8801714231625'); ?>

                                    </span>
                                </div>
                                <div class="d-none d-sm-block">
                                    <i class="fa-solid fa-envelope"></i>
                                    <span>
                                        <?php echo e($generaleSetting?->footer_email ?? 'razinsoftltd@gmail.com'); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>

    <!-- Logout Form -->
    <?php
        $action = request()->is('admin/*', 'admin') ? route('admin.logout') : route('shop.logout');
    ?>
    <form action="<?php echo e($action); ?>" method="POST" id="logoutForm">
        <?php echo csrf_field(); ?>
    </form>

    <script src="<?php echo e(asset('assets/scripts/jquery-3.6.3.min.js')); ?>"></script>
    <!-- Bootstrap-Min-Bundil-Link -->
    <script src="<?php echo e(asset('assets/scripts/bootstrap.bundle.min.js')); ?>"></script>
    <!-- Main-Script-Js-Link -->
    <script src="<?php echo e(asset('assets/scripts/main.js')); ?>"></script>

    <!-- Apex-Charts-Js-Link -->
    <script src="<?php echo e(asset('assets/scripts/apexcharts.min.js')); ?>"></script>

    <!-- Full-Screen-Js-Link -->
    <script src="<?php echo e(asset('assets/scripts/full-screen.js')); ?>"></script>

    <!--select2 -->
    <script src="<?php echo e(asset('assets/scripts/select2.min.js')); ?>"></script>

    <!-- sweetalert js-->
    <script src="<?php echo e(asset('assets/scripts/sweetalert2.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/scripts/datatables.min.js')); ?>"></script>

    <!-- quill  editor-->
    <script src="<?php echo e(asset('assets/scripts/quill.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/scripts/jQuery.print.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/scripts/script.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/scripts/toastr.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/scripts/jquery.timepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/scripts/jquery-ui.js')); ?>"></script>

    <!-- Pusher-Js-Link -->
    <script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });

        document.addEventListener("DOMContentLoaded", function() {
            var themeColor = "<?php echo e($generaleSetting?->primary_color ?? '#ef6d25'); ?>";
            var themeHoverColor = "<?php echo e($generaleSetting?->secondary_color ?? '#fce2d3'); ?>";
            document.documentElement.style.setProperty('--theme-color', themeColor);
            document.documentElement.style.setProperty('--theme-hover-bg', themeHoverColor);
        });

        // Fetch Admin Notifications
        const fetchAdminNotifications = () => {
            $.ajax({
                type: 'GET',
                url: "<?php echo e(route('admin.dashboard.notification')); ?>",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                dataType: 'json',
                success: function(response) {
                    $('#totalNotify').text(response.data.total)
                    $('#notifications').empty()
                    $.each(response.data.notifications, function(key, value) {
                        var id = value.id;
                        var link = "<?php echo e(route('admin.notification.read', ':id')); ?>";
                        link = link.replace(':id', id);
                        $('#notifications').append(
                            `<a href="${link}" class="item d-flex gap-2 align-items-center">
                            <div class="iconBox ${value.type == 'danger' ? 'cardIcon' : 'pdfIcon'}">
                                <i class="bi ${value.icon}"></i>
                            </div>
                            <div class="notification w-100 ${!value.is_read ? 'unread' : ''}">
                                <div class="userName">
                                    <p class="massTitel">${value.title} </p>
                                    <span class="time">${value.time}</span>
                                </div>
                                <div>
                                    <p class="description">${value.content}</p>
                                </div>
                            </div>
                        </a>`
                        );
                    })
                },
                error: function(e) {
                    $('#notifications').empty()
                    if (e.status == 401 || e.status == 403) {
                        $('#totalNotify').text(0)
                        $("#notifications").html("emply");
                    }else{
                        $("#notifications").html(e.responseText);
                    }
                }
            });
        }

        // fetch shop notifications
        const fetchShopNotifications = () => {
            $.ajax({
                type: 'GET',
                url: "<?php echo e(route('shop.dashboard.notification')); ?>",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                dataType: 'json',
                success: function(response) {
                    $('#totalNotify').text(response.data.total)
                    $('#notifications').empty()
                    $.each(response.data.notifications, function(key, value) {
                        var id = value.id;
                        var link = "<?php echo e(route('shop.notification.read', ':id')); ?>";
                        link = link.replace(':id', id);
                        $('#notifications').append(
                            `<a href="${link}" class="item d-flex gap-2 align-items-center">
                            <div class="iconBox ${value.type == 'danger' ? 'cardIcon' : 'pdfIcon'}">
                                <i class="bi ${value.icon}"></i>
                            </div>
                            <div class="notification w-100 ${!value.is_read ? 'unread' : ''}">
                                <div class="userName">
                                    <p class="massTitel">${value.title} </p>
                                    <span class="time">${value.time}</span>
                                </div>
                                <div>
                                    <p class="description">${value.content}</p>
                                </div>
                            </div>
                        </a>`
                        );
                    })
                },
                error: function(e) {
                    $('#notifications').empty()
                    if (e.status == 401 || e.status == 403) {
                        $('#totalNotify').text(0)
                        $("#notifications").html("emply");
                    }else{
                        $("#notifications").html(e.responseText);
                    }
                }
            });
        }
    </script>

    <!-- Pusher Scripts -->
    <script>
        var pusher = new Pusher("<?php echo e(config('broadcasting.connections.pusher.key')); ?>", {
            cluster: "<?php echo e(config('broadcasting.connections.pusher.options.cluster')); ?>",
        });

        var channel = pusher.subscribe('notification-channel');
    </script>

    <!-- Show Notifications Using Pusher JS -->

    <?php if(request()->is('admin/*', 'admin')): ?>
        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.dashboard.notification')): ?>
            <script>
                channel.bind('admin-product-request', function(data) {
                    var message = data.message;
                    if (message.startsWith('"') && message.endsWith('"')) {
                        message = message.slice(1, -1);
                    }
                    toastr.success(message)
                    // new Audio("<?php echo e(asset('assets/audio/notification.mp3')); ?>").play();
                    fetchAdminNotifications()
                });

                channel.bind('support-ticket-event', function(data) {
                    var message = data.message;
                    if (message.startsWith('"') && message.endsWith('"')) {
                        message = message.slice(1, -1);
                    }
                    toastr.success(message)
                    fetchAdminNotifications()
                });

                fetchAdminNotifications() // fetch Admin Notifications
            </script>
        <?php endif; ?>
    <?php else: ?>
        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.dashboard.notification')): ?>
            <script>
                var shopID = "<?php echo e(generaleSetting('shop')?->id); ?>";
                channel.bind('product-approve-event', function(data) {
                    var requestShopId = data.shop_id;
                    var message = data.message;
                    if (requestShopId == shopID) {
                        if (message.startsWith('"') && message.endsWith('"')) {
                            message = message.slice(1, -1);
                        }
                        toastr.success(message)
                        fetchShopNotifications()
                    }
                });
                fetchShopNotifications() // fetch Shop Notifications
            </script>
        <?php endif; ?>
    <?php endif; ?>

    <script>
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>

    <?php if(session('success')): ?>
        <script>
            Toast.fire({
                icon: 'success',
                title: '<?php echo e(session('success')); ?>'
            })
        </script>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <script>
            Toast.fire({
                icon: 'error',
                title: "<?php echo e(session('error')); ?>"
            })
        </script>
    <?php endif; ?>

    <?php if(session('demoMode')): ?>
        <script>
            Swal.fire({
                icon: "error",
                title: "Oops...",
                text: "<?php echo e(session('demoMode')); ?>",
            });
        </script>
    <?php endif; ?>

    <?php if(session('alertError')): ?>
        <script>
            Swal.fire({
                icon: "error",
                title: "Oops...",
                html: `<?php echo e(session('alertError')['message']); ?> <br><br> <?php echo e(isset(session('alertError')['message2']) ? session('alertError')['message2'] : ''); ?>`,
            });
        </script>
    <?php endif; ?>

    <Script>
        document.addEventListener("DOMContentLoaded", function() {
            var root = document.documentElement;

            // Get the value of --theme-color
            var themeColor = getComputedStyle(root).getPropertyValue("--theme-color");

            $(".deleteConfirm").on("click", function(e) {
                e.preventDefault();
                const url = $(this).attr("href");
                Swal.fire({
                    title: "<?php echo e(__('Are you sure?')); ?>",
                    text: '<?php echo e(__('You will not be able to revert this!')); ?>',
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: themeColor,
                    cancelButtonColor: "#d33",
                    confirmButtonText: "<?php echo e(__('Yes, delete it!')); ?>",
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = url;
                    }
                });
            });

            $(".logout").on("click", function(e) {
                e.preventDefault();
                Swal.fire({
                    title: "<?php echo e(__('Are you sure?')); ?>",
                    text: "<?php echo e(__('Are you sure you want to log out?')); ?>",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: themeColor,
                    cancelButtonColor: "#d33",
                    confirmButtonText: "<?php echo e(__('Yes, Logout!')); ?>",
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("logoutForm").submit();
                    }
                });
            });

            // form submit loader
            $('form').on('submit', function() {
                var submitButton = $(this).find('button[type="submit"]');

                submitButton.prop('disabled', true);
                submitButton.removeClass('px-5');

                submitButton.html(`<div class="d-flex align-items-center gap-1">
                    <div class="spinner-border spinner-border-sm" role="status"></div>
                    <span>Loading...</span>
                </div>`)
            });
        });
    </Script>

</body>

</html>
<?php /**PATH /Users/abedin.dev/Code/maya-mart/resources/views/layouts/app.blade.php ENDPATH**/ ?>