<?php $__env->startSection('content'); ?>
    <div class="app-page-title">
        <div class="page-title-wrapper">
            <div class="page-title-heading">
                <div> <?php echo e(__('Dashboard')); ?>

                    <div class="page-title-subheading">
                        <?php echo e(__('This is a admin dashboard')); ?>.
                    </div>
                </div>
            </div>
        </div>

        <?php if(app()->environment('local')): ?>
            <div class="alert alert-danger d-flex align-items-center gap-1 justify-content-between mt-2 mb-0" role="alert"
                id="alertBox">
                <div class="d-flex align-items-center gap-2">
                    <i class="fa-solid fa-bell"></i>
                    <div>
                        <strong><?php echo e(__('Note')); ?></strong> <?php echo e(__('Every 3 hours all data will be cleared')); ?>

                    </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

    </div>

    <?php
        $text = 'Total ' . ($businessModel == 'single' ? 'Categories' : 'Shops');
    ?>

    <!-- Flash Deal Alert -->
    <?php if($flashSale): ?>
        <div>
            <div class="alert flash-deal-alert d-flex justify-content-between align-items-center">
                <div>
                    <div class="deal-title"><?php echo e(__('Flash Sale Coming Soon')); ?></div>
                    <span class="deal-text"><?php echo e($flashSale->name); ?></span>
                </div>
                <div class="countdown d-flex align-items-center">
                    <!-- Days -->
                    <div class="countdown-section">
                        <div class="countdown-label">Days</div>
                        <div id="days" class="countdown-time">00</div>
                    </div>
                    <!-- Hours -->
                    <div class="countdown-section">
                        <div class="countdown-label">Hours</div>
                        <div id="hours" class="countdown-time">00</div>
                    </div>
                    <!-- Minutes -->
                    <div class="countdown-section">
                        <div class="countdown-label">Minutes</div>
                        <div id="minutes" class="countdown-time">00</div>
                    </div>
                    <!-- Seconds -->
                    <div class="countdown-section">
                        <div class="countdown-label">Seconds</div>
                        <div id="seconds" class="countdown-time">00</div>
                    </div>
                </div>
                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.flashSale.show')): ?>
                    <a href="<?php echo e(route('shop.flashSale.show', $flashSale->id)); ?>" class="btn btn-primary py-2.5">
                        Add Product
                    </a>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
    <!-- End Flash Deal Alert -->

    <div class="row">
        <div class="col-md-6 col-lg-4 col-xl-3 mb-3">
            <div class="dashboard-summery bg-shop">
                <h2><?php echo e($businessModel == 'single' ? $totalCategories : $totalShop); ?></h2>
                <h3><?php echo e(__($text)); ?></h3>
                <div class="icon">
                    <i class="bi bi-shop"></i>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-4 col-xl-3 mb-3">
            <div class="dashboard-summery bg-midnight-bloom">
                <h2><?php echo e($totalProduct); ?></h2>
                <h3><?php echo e(__('Total Products')); ?></h3>
                <div class="icon">
                    <i class="bi bi-basket"></i>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-4 col-xl-3 mb-3">
            <div class="dashboard-summery bg-alternate">
                <h2><?php echo e($totalOrder); ?></h2>
                <h3><?php echo e(__('Total Orders')); ?></h3>
                <div class="icon">
                    <i class="bi bi-cart-check"></i>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-4 col-xl-3 mb-3">
            <div class="dashboard-summery bg-grow-early">
                <h2><?php echo e($totalCustomer); ?></h2>
                <h3><?php echo e(__('Total Customers')); ?></h3>
                <div class="icon">
                    <i class="bi bi-person-circle"></i>
                </div>
            </div>
        </div>
    </div>

    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.order.index')): ?>
        <!---- Order Analytics -->
        <div class="card">
            <div class="card-body">
                <div class="cardTitleBox">
                    <h5 class="card-title chartTitle">
                        <i class="bi bi-bar-chart"></i> <?php echo e(__('Order Analytics')); ?>

                    </h5>
                </div>

                <?php
                    $icons = [
                        'pending' => 'bi-clock',
                        'confirm' => 'bi-bag-check-fill',
                        'processing' => 'bi-arrow-repeat',
                        'pickup' => 'bi-bicycle',
                        'delivered' => 'bi-patch-check-fill',
                        'onTheWay' => 'bi-bicycle',
                        'cancelled' => 'bi-x-circle',
                    ];
                ?>

                <div class="d-flex flex-wrap gap-3 orderStatus">
                    <?php $__currentLoopData = $orderStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('admin.order.index', str_replace(' ', '_', $status->value))); ?>"
                            class="d-flex align-items-center gap-3 status flex-grow-1">
                            <div>
                                <i class="bi <?php echo e($icons[Str::camel($status->value)]); ?>"></i>
                                <span><?php echo e(__($status->value)); ?></span>
                            </div>
                            <span class="count"><?php echo e(${Str::camel($status->value)}); ?></span>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!---- Shop Wallet -->
    <div class="card mt-4">
        <div class="card-body">
            <div class="cardTitleBox">
                <h5 class="card-title chartTitle">
                    <i class="bi bi-wallet2"></i> <?php echo e(__('Admin Wallet')); ?>

                </h5>
            </div>

            <div class="row">
                <div class="col-md-5">
                    <div class="wallet py-4 px-3">
                        <div class="wallet-icon">
                            <img src="<?php echo e(asset('assets/images/wallet.png')); ?>" alt="" width="100%">
                        </div>
                        <h3 class="balance"><?php echo e(showCurrency(auth()->user()->wallet->balance)); ?></h3>

                        <div class="title"><?php echo e(__('Total Earning')); ?></div>
                    </div>
                </div>

                <div class="col-md-7">
                    <div class="row gy-4">

                        <div class="col-md-6">
                            <div class="wallet-others py-md-4">
                                <div>
                                    <div class="amount"><?php echo e(showCurrency($alreadyWithdraw)); ?></div>
                                    <div class="title"><?php echo e(__('Already Withdraw')); ?></div>
                                </div>
                                <div class="icon">
                                    <img src="<?php echo e(asset('assets/icons/alreadyWithdraw.png')); ?>" alt="icon" />
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="wallet-others py-md-4">
                                <div>
                                    <div class="amount"><?php echo e(showCurrency($pendingWithdraw)); ?></div>
                                    <div class="title"><?php echo e(__('Pending Withdraw')); ?></div>
                                </div>
                                <div class="icon">
                                    <img src="<?php echo e(asset('assets/icons/pendingWithdraw.png')); ?>" alt="icon" />
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="wallet-others py-md-4">
                                <div>
                                    <div class="amount"><?php echo e(showCurrency($totalCommission)); ?></div>
                                    <div class="title"><?php echo e(__('Total Commission')); ?></div>
                                </div>
                                <div class="icon">
                                    <img src="<?php echo e(asset('assets/icons/totalEarn.png')); ?>" alt="icon" />
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="wallet-others py-md-4">
                                <div>
                                    <div class="amount"><?php echo e(showCurrency($deniedWithddraw)); ?></div>
                                    <div class="title"><?php echo e(__('Rejected Withdraw')); ?></div>
                                </div>
                                <div class="icon">
                                    <img src="<?php echo e(asset('assets/icons/reject.png')); ?>" alt="icon" />
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- User Overview -->
    <div class="row">
        <div class="col-xxl-8 mt-3">
            <div class="card">
                <div class="card-body">
                    <div class="cardTitleBox">
                        <h5 class="card-title chartTitle"><?php echo e(__('Orders Summary')); ?></h5>
                        <p class="lastAll"><i class="bi bi-calendar-date pe-1"></i>
                            <?php echo e(__('latest 6th orders')); ?>

                        </p>
                    </div>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th><strong><?php echo e(__('Order ID')); ?></strong></th>
                                    <th><strong><?php echo e(__('Qty')); ?></strong></th>
                                    <?php if($businessModel == 'multi'): ?>
                                        <th><strong><?php echo e(__('Shop')); ?></strong></th>
                                    <?php endif; ?>
                                    <th><strong><?php echo e(__('Date')); ?></strong></th>
                                    <th><strong><?php echo e(__('Status')); ?></strong></th>
                                    <th><strong><?php echo e(__('Action')); ?></strong></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $latestOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="tableId">#<?php echo e($order->prefix . $order->order_code); ?></td>
                                        <td class="tableId">
                                            <?php echo e($order->products->count()); ?>

                                        </td>
                                        <?php if($businessModel == 'multi'): ?>
                                            <td class="tableCustomar">
                                                <?php echo e($order->shop?->name); ?>

                                            </td>
                                        <?php endif; ?>
                                        <td class="tableId">
                                            <?php echo e($order->created_at->format('d M, Y')); ?>

                                        </td>
                                        <?php
                                            $status = Str::ucfirst(str_replace(' ', '', $order->order_status->value));
                                        ?>
                                        <td class="tableStatus">
                                            <div class="statusItem">
                                                <div class="circleDot animated<?php echo e($status); ?>"></div>
                                                <div class="statusText">
                                                    <span class="status<?php echo e($status); ?>">
                                                        <?php echo e($order->order_status->value); ?>

                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="tableAction">
                                            <a href="<?php echo e(route('admin.order.show', $order->id)); ?>"
                                                data-bs-toggle="tooltip" data-bs-placement="left"
                                                data-bs-title="Order details"
                                                class="circleIcon btn btn-sm btn-outline-secondary">
                                                <i class="bi bi-eye-fill"></i>
                                            </a>
                                            <a href="<?php echo e(route('shop.download-invoice', $order->id)); ?>"
                                                data-bs-toggle="tooltip" data-bs-placement="left"
                                                data-bs-title="Download Invoice"
                                                class="circleIcon btn-outline-success btn btn-sm">
                                                <i class="bi bi-arrow-down-circle"></i>
                                            </a>
                                        </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-4 mt-3">
            <div class="card h-100">
                <div class="card-header py-3">
                    <h5 class="card-title m-0">
                        <i class="bi bi-person fz-16"></i> <?php echo e(__('User Overview')); ?>

                    </h5>
                </div>
                <div class="card-body">
                    <div id="donut"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <!-- Top Customer -->
        <div class="col-xxl-4 col-lg-6 mt-3">
            <div class="card">
                <div class="card-body">
                    <div class="cardTitleBox">
                        <h5 class="card-title chartTitle">
                            <i class="bi bi-people fz-18"></i> <?php echo e(__('Top Customer')); ?>

                        </h5>
                    </div>

                    <div class="d-flex flex-column gap-1">
                        <?php $__currentLoopData = $topCustomers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="customar-section">
                                <div class="customat-details">
                                    <div class="customar-image">
                                        <img src="<?php echo e($customer->user?->thumbnail); ?>" alt="">
                                    </div>
                                    <div class="customar-about">
                                        <p class="name"><?php echo e(Str::limit($customer->user?->name, 30, '...')); ?></p>
                                        <p class="order">
                                            <?php echo e(__('Orders')); ?>:
                                            <span class=""><?php echo e($customer->orders_count); ?></span>
                                        </p>
                                    </div>
                                </div>
                                <div class="customar-socal-icon">
                                    <a href="#" class="circleIcon btn btn-outline-dark">
                                        <i class="bi bi-eye-fill"></i>
                                    </a>

                                    <a href="#" class="circleIcon btn btn-outline-dark">
                                        <i class="bi bi-bookmark-check-fill"></i>
                                    </a>

                                    <a href="#" class="circleIcon btn btn-outline-dark">
                                        <i class="bi bi-three-dots-vertical"></i>
                                    </a>

                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                </div>
            </div>
        </div>

        <?php if($businessModel == 'multi'): ?>
            <!-- Top Shops -->
            <div class="col-xxl-4 col-lg-6 mt-3">
                <div class="card">
                    <div class="card-body">
                        <div class="cardTitleBox">
                            <h5 class="card-title chartTitle">
                                <i class="bi bi-shop fz-16"></i> <?php echo e(__('Top Trending Shops')); ?>

                            </h5>
                        </div>

                        <div class="d-flex flex-column gap-1">
                            <?php $__currentLoopData = $topShops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('admin.shop.show', $shop->id)); ?>" class="customar-section">
                                    <div class="customat-details">
                                        <div class="customar-image">
                                            <img src="<?php echo e($shop->logo); ?>" alt="">
                                        </div>
                                        <div class="customar-about">
                                            <p class="name text-dark">
                                                <?php echo e(Str::limit($shop->name, 30, '...')); ?>

                                            </p>
                                            <p class="order">
                                                <i class="bi bi-star-fill text-warning"></i>
                                                <i class="bi bi-star-half text-warning"></i>
                                                <?php echo e($shop->average_rating); ?>

                                            </p>
                                        </div>
                                    </div>
                                    <div class="border rounded text-primary px-2 py-1 flex-shrink-0"
                                        style="font-size: 13px">
                                        <div><?php echo e(__('Orders')); ?>: <?php echo e($shop->orders_count); ?></div>
                                    </div>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Top Selling Products -->
        <div class="col-xxl-4 col-lg-6 mt-3">
            <div class="card">
                <div class="card-body">
                    <div class="cardTitleBox">
                        <h5 class="card-title chartTitle">
                            <i class="bi bi-bag-check fz-16"></i> <?php echo e(__('Top Selling Products')); ?>

                        </h5>
                    </div>

                    <div class="d-flex flex-column gap-1">
                        <?php $__currentLoopData = $topSellingProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('admin.product.show', $product->id)); ?>" class="customar-section">
                                <div class="customat-details">
                                    <div class="customar-image">
                                        <img src="<?php echo e($product->thumbnail); ?>" alt="">
                                    </div>
                                    <div class="customar-about">
                                        <p class="text-dark name">
                                            <?php echo e(Str::limit($product->name, 30, '...')); ?>

                                        </p>
                                        <p class="order"><?php echo e(__('Rating')); ?>:
                                            <?php echo e(number_format($product->reviews->avg('rating'), 1)); ?>

                                        </p>
                                    </div>
                                </div>
                                <div class="border rounded text-primary px-2 py-1 flex-shrink-0" style="font-size: 13px">
                                    <div><?php echo e(__('Sold')); ?>: <?php echo e($product->orders_count); ?></div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Rating Products -->
        <div class="col-xxl-4 col-lg-6 mt-3">
            <div class="card">
                <div class="card-body">
                    <div class="cardTitleBox">
                        <h5 class="card-title chartTitle">
                            <i class="bi bi-stars fz-16"></i> <?php echo e(__('Top Rating Products')); ?>

                        </h5>
                    </div>

                    <div class="d-flex flex-column gap-1">
                        <?php $__currentLoopData = $topReviewProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('admin.product.show', $product->id)); ?>" class="customar-section">
                                <div class="customat-details">
                                    <div class="customar-image">
                                        <img src="<?php echo e($product->thumbnail); ?>" alt="">
                                    </div>
                                    <div class="customar-about">
                                        <p class="name text-dark"><?php echo e(Str::limit($product->name, 30, '...')); ?></p>
                                        <p class="order"><?php echo e(__('Sold')); ?>: <?php echo e($product->orders->count()); ?></p>
                                    </div>
                                </div>
                                <div class="border rounded text-primary px-2 py-1 flex-shrink-0" style="font-size: 13px">
                                    <div><?php echo e(__('Rating')); ?>: <i class="bi bi-star-fill text-warning"></i>
                                        <?php echo e(number_format($product->average_rating, 1)); ?></div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Most Favorite Products -->
        <div class="col-xxl-4 col-lg-6 mt-3">
            <div class="card">
                <div class="card-body">
                    <div class="cardTitleBox">
                        <h5 class="card-title chartTitle">
                            <i class="bi bi-bag-heart fz-16"></i> <?php echo e(__('Most Favorite Products')); ?>

                        </h5>
                    </div>

                    <div class="d-flex flex-column gap-1">
                        <?php $__currentLoopData = $topFavorites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('admin.product.show', $product->id)); ?>" class="customar-section">
                                <div class="customat-details">
                                    <div class="customar-image">
                                        <img src="<?php echo e($product->thumbnail); ?>" alt="">
                                    </div>
                                    <div class="customar-about">
                                        <p class="name text-dark"><?php echo e(Str::limit($product->name, 30, '...')); ?></p>
                                        <div class="d-flex gap-2 align-items-center">
                                            <p class="order">Sold: <?php echo e($product->orders->count()); ?></p>
                                            <div class="border-start" style="width: 1px; height: 14px;"></div>
                                            <p class="order">
                                                <?php echo e(__('Rating')); ?>: <i class="bi bi-star-fill text-warning"></i>
                                                <?php echo e(number_format($product->average_rating, 1)); ?>

                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="border rounded text-danger px-2 py-1 flex-shrink-0" style="font-size: 16px">
                                    <div><?php echo e($product->favorites_count); ?> <i class="bi bi-heart-fill text-danger"></i>
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>

    </div>


    <style>
        .apexcharts-legend-series {
            margin: 6px 5px !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        const hideAlert = () => {
            setTimeout(() => {
                document.getElementById('alertBox')?.classList.add('d-none');
            }, 5000);
        }

        hideAlert();

        var optionDonut = {
            chart: {
                type: 'donut',
                width: '100%',
                height: 320
            },
            dataLabels: {
                enabled: false,
            },
            plotOptions: {
                pie: {
                    customScale: 0.8,
                    donut: {
                        size: '65%',
                        labels: {
                            show: true,
                            name: {
                                show: true,
                                fontSize: '18px',
                                color: undefined,
                            },
                            value: {
                                show: true,
                                fontSize: '24px',
                                color: undefined,
                                formatter: function(val) {
                                    return val
                                }
                            }
                        }
                    },
                    offsetY: 20,
                },
                stroke: {
                    colors: undefined
                }
            },
            colors: ['#00D8B6', '#6d28d9', '#0d9488'],
            series: [<?php echo e($totalCustomer); ?>, <?php echo e($totalShop); ?>, 0],
            labels: ["<?php echo e(__('Customer')); ?>", "<?php echo e(__('Shop')); ?>", "<?php echo e(__('Rider')); ?>"],
            legend: {
                position: 'left',
                fontSize: '16px',
                offsetY: 100
            }
        }

        var donut = new ApexCharts(
            document.querySelector("#donut"),
            optionDonut
        )
        donut.render();
    </script>
    <?php if($flashSale): ?>
        <script>
            // Set the start and end date/time
            var startDateAndTime = "<?php echo e($flashSale->start_date); ?>T<?php echo e($flashSale->start_time); ?>";
            var endDateAndTime = "<?php echo e($flashSale->end_date); ?>T<?php echo e($flashSale->end_time); ?>";
            let startDate = new Date(startDateAndTime).getTime();
            let endDate = new Date(endDateAndTime).getTime();

            // Update the countdown every 1 second
            let countdownInterval = setInterval(() => {
                let now = new Date().getTime();

                // If current time is before the start date, show "Deal Coming" message
                if (now < startDate) {
                    let distanceToStart = startDate - now;

                    // Time calculations for days, hours, minutes, and seconds
                    let days = Math.floor(distanceToStart / (1000 * 60 * 60 * 24));
                    let hours = Math.floor((distanceToStart % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    let minutes = Math.floor((distanceToStart % (1000 * 60 * 60)) / (1000 * 60));
                    let seconds = Math.floor((distanceToStart % (1000 * 60)) / 1000);

                    // Display the countdown with a "Deal Coming" message
                    document.getElementById("days").innerHTML = String(days).padStart(2, '0');
                    document.getElementById("hours").innerHTML = String(hours).padStart(2, '0');
                    document.getElementById("minutes").innerHTML = String(minutes).padStart(2, '0');
                    document.getElementById("seconds").innerHTML = String(seconds).padStart(2, '0');
                    return;
                }

                // Once the current time is after the start date and before the end date, show the active countdown
                let distance = endDate - now;

                // If the deal has ended, stop the countdown and show the message
                if (distance < 0) {
                    clearInterval(countdownInterval);
                    document.getElementById("days").innerHTML = "00";
                    document.getElementById("hours").innerHTML = "00";
                    document.getElementById("minutes").innerHTML = "00";
                    document.getElementById("seconds").innerHTML = "00";
                    document.querySelector(".deal-text").innerHTML = "Deal Ended!";
                    return;
                }

                // Time calculations for days, hours, minutes, and seconds
                let days = Math.floor(distance / (1000 * 60 * 60 * 24));
                let hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                let minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                let seconds = Math.floor((distance % (1000 * 60)) / 1000);

                // Display the result
                document.getElementById("days").innerHTML = String(days).padStart(2, '0');
                document.getElementById("hours").innerHTML = String(hours).padStart(2, '0');
                document.getElementById("minutes").innerHTML = String(minutes).padStart(2, '0');
                document.getElementById("seconds").innerHTML = String(seconds).padStart(2, '0');
            }, 1000);
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        /* Flash Deal Alert Styles */
        .flash-deal-alert {
            background: linear-gradient(90deg, #9b34ff, #617eff);
            color: white;
            border-radius: 8px;
            padding: 8px 15px;
        }

        .deal-title {
            font-size: 20px;
        }

        .deal-text {
            font-size: 16px;
        }

        /* Countdown Timer Styles */
        .countdown {
            display: flex;
            gap: 20px;
            /* Space between sections */
        }

        .countdown-section {
            text-align: center;
        }

        .countdown-label {
            font-size: 14px;
            font-weight: bold;
        }

        .countdown-time {
            width: 46px;
            height: 46px;
            font-size: 20px;
            font-weight: bold;
            margin-top: 5px;
            border: 1px solid var(--theme-color);
            padding: 5px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            background-color: var(--theme-color);
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/abedin.dev/Code/maya-mart/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>