<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The billing cycle providing details of the billing frequency, amount, duration and if the billing
 * cycle is a free, discounted or regular billing cycle. The sequence of the billing cycle will be in
 * the following order - free trial billing cycle(s), discounted trial billing cycle(s), regular
 * billing cycle(s).
 */
class BillingCycle implements \JsonSerializable
{
    /**
     * @var string
     */
    private $tenureType;

    /**
     * @var PricingScheme|null
     */
    private $pricingScheme;

    /**
     * @var mixed
     */
    private $frequency;

    /**
     * @var int|null
     */
    private $totalCycles = 1;

    /**
     * @var int|null
     */
    private $sequence = 1;

    /**
     * @var string|null
     */
    private $startDate;

    /**
     * @param string $tenureType
     */
    public function __construct(string $tenureType)
    {
        $this->tenureType = $tenureType;
    }

    /**
     * Returns Tenure Type.
     * The tenure type of the billing cycle identifies if the billing cycle is a trial(free or discounted)
     * or regular billing cycle.
     */
    public function getTenureType(): string
    {
        return $this->tenureType;
    }

    /**
     * Sets Tenure Type.
     * The tenure type of the billing cycle identifies if the billing cycle is a trial(free or discounted)
     * or regular billing cycle.
     *
     * @required
     * @maps tenure_type
     */
    public function setTenureType(string $tenureType): void
    {
        $this->tenureType = $tenureType;
    }

    /**
     * Returns Pricing Scheme.
     * The pricing scheme details.
     */
    public function getPricingScheme(): ?PricingScheme
    {
        return $this->pricingScheme;
    }

    /**
     * Sets Pricing Scheme.
     * The pricing scheme details.
     *
     * @maps pricing_scheme
     */
    public function setPricingScheme(?PricingScheme $pricingScheme): void
    {
        $this->pricingScheme = $pricingScheme;
    }

    /**
     * Returns Frequency.
     * The frequency details for this billing cycle.
     *
     * @return mixed
     */
    public function getFrequency()
    {
        return $this->frequency;
    }

    /**
     * Sets Frequency.
     * The frequency details for this billing cycle.
     *
     * @maps frequency
     *
     * @param mixed $frequency
     */
    public function setFrequency($frequency): void
    {
        $this->frequency = $frequency;
    }

    /**
     * Returns Total Cycles.
     * The number of times this billing cycle gets executed. Trial billing cycles can only be executed a
     * finite number of times (value between 1 and 999 for total_cycles). Regular billing cycles can be
     * executed infinite times (value of 0 for total_cycles) or a finite number of times (value between 1
     * and 999 for total_cycles).
     */
    public function getTotalCycles(): ?int
    {
        return $this->totalCycles;
    }

    /**
     * Sets Total Cycles.
     * The number of times this billing cycle gets executed. Trial billing cycles can only be executed a
     * finite number of times (value between 1 and 999 for total_cycles). Regular billing cycles can be
     * executed infinite times (value of 0 for total_cycles) or a finite number of times (value between 1
     * and 999 for total_cycles).
     *
     * @maps total_cycles
     */
    public function setTotalCycles(?int $totalCycles): void
    {
        $this->totalCycles = $totalCycles;
    }

    /**
     * Returns Sequence.
     * The order in which this cycle is to run among other billing cycles. For example, a trial billing
     * cycle has a `sequence` of `1` while a regular billing cycle has a `sequence` of `2`, so that trial
     * cycle runs before the regular cycle.
     */
    public function getSequence(): ?int
    {
        return $this->sequence;
    }

    /**
     * Sets Sequence.
     * The order in which this cycle is to run among other billing cycles. For example, a trial billing
     * cycle has a `sequence` of `1` while a regular billing cycle has a `sequence` of `2`, so that trial
     * cycle runs before the regular cycle.
     *
     * @maps sequence
     */
    public function setSequence(?int $sequence): void
    {
        $this->sequence = $sequence;
    }

    /**
     * Returns Start Date.
     * The stand-alone date, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-
     * 5.6). To represent special legal values, such as a date of birth, you should use dates with no
     * associated time or time-zone data. Whenever possible, use the standard `date_time` type. This
     * regular expression does not validate all dates. For example, February 31 is valid and nothing is
     * known about leap years.
     */
    public function getStartDate(): ?string
    {
        return $this->startDate;
    }

    /**
     * Sets Start Date.
     * The stand-alone date, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-
     * 5.6). To represent special legal values, such as a date of birth, you should use dates with no
     * associated time or time-zone data. Whenever possible, use the standard `date_time` type. This
     * regular expression does not validate all dates. For example, February 31 is valid and nothing is
     * known about leap years.
     *
     * @maps start_date
     */
    public function setStartDate(?string $startDate): void
    {
        $this->startDate = $startDate;
    }

    /**
     * Converts the BillingCycle object to a human-readable string representation.
     *
     * @return string The string representation of the BillingCycle object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'BillingCycle',
            [
                'tenureType' => $this->tenureType,
                'pricingScheme' => $this->pricingScheme,
                'frequency' => $this->frequency,
                'totalCycles' => $this->totalCycles,
                'sequence' => $this->sequence,
                'startDate' => $this->startDate
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['tenure_type']        = $this->tenureType;
        if (isset($this->pricingScheme)) {
            $json['pricing_scheme'] = $this->pricingScheme;
        }
        if (isset($this->frequency)) {
            $json['frequency']      = $this->frequency;
        }
        if (isset($this->totalCycles)) {
            $json['total_cycles']   = $this->totalCycles;
        }
        if (isset($this->sequence)) {
            $json['sequence']       = $this->sequence;
        }
        if (isset($this->startDate)) {
            $json['start_date']     = $this->startDate;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
