<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Customizes the payer experience during the approval process for the BLIK payment.
 */
class BlikExperienceContext implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $brandName;

    /**
     * @var string|null
     */
    private $locale;

    /**
     * @var string|null
     */
    private $shippingPreference = ShippingPreference::GET_FROM_FILE;

    /**
     * @var string|null
     */
    private $returnUrl;

    /**
     * @var string|null
     */
    private $cancelUrl;

    /**
     * @var string|null
     */
    private $consumerIp;

    /**
     * @var string|null
     */
    private $consumerUserAgent;

    /**
     * Returns Brand Name.
     * The label that overrides the business name in the PayPal account on the PayPal site. The pattern is
     * defined by an external party and supports Unicode.
     */
    public function getBrandName(): ?string
    {
        return $this->brandName;
    }

    /**
     * Sets Brand Name.
     * The label that overrides the business name in the PayPal account on the PayPal site. The pattern is
     * defined by an external party and supports Unicode.
     *
     * @maps brand_name
     */
    public function setBrandName(?string $brandName): void
    {
        $this->brandName = $brandName;
    }

    /**
     * Returns Locale.
     * The [language tag](https://tools.ietf.org/html/bcp47#section-2) for the language in which to
     * localize the error-related strings, such as messages, issues, and suggested actions. The tag is made
     * up of the [ISO 639-2 language code](https://www.loc.gov/standards/iso639-2/php/code_list.php), the
     * optional [ISO-15924 script tag](https://www.unicode.org/iso15924/codelists.html), and the [ISO-3166
     * alpha-2 country code](/api/rest/reference/country-codes/) or [M49 region code](https://unstats.un.
     * org/unsd/methodology/m49/).
     */
    public function getLocale(): ?string
    {
        return $this->locale;
    }

    /**
     * Sets Locale.
     * The [language tag](https://tools.ietf.org/html/bcp47#section-2) for the language in which to
     * localize the error-related strings, such as messages, issues, and suggested actions. The tag is made
     * up of the [ISO 639-2 language code](https://www.loc.gov/standards/iso639-2/php/code_list.php), the
     * optional [ISO-15924 script tag](https://www.unicode.org/iso15924/codelists.html), and the [ISO-3166
     * alpha-2 country code](/api/rest/reference/country-codes/) or [M49 region code](https://unstats.un.
     * org/unsd/methodology/m49/).
     *
     * @maps locale
     */
    public function setLocale(?string $locale): void
    {
        $this->locale = $locale;
    }

    /**
     * Returns Shipping Preference.
     * The location from which the shipping address is derived.
     */
    public function getShippingPreference(): ?string
    {
        return $this->shippingPreference;
    }

    /**
     * Sets Shipping Preference.
     * The location from which the shipping address is derived.
     *
     * @maps shipping_preference
     */
    public function setShippingPreference(?string $shippingPreference): void
    {
        $this->shippingPreference = $shippingPreference;
    }

    /**
     * Returns Return Url.
     * Describes the URL.
     */
    public function getReturnUrl(): ?string
    {
        return $this->returnUrl;
    }

    /**
     * Sets Return Url.
     * Describes the URL.
     *
     * @maps return_url
     */
    public function setReturnUrl(?string $returnUrl): void
    {
        $this->returnUrl = $returnUrl;
    }

    /**
     * Returns Cancel Url.
     * Describes the URL.
     */
    public function getCancelUrl(): ?string
    {
        return $this->cancelUrl;
    }

    /**
     * Sets Cancel Url.
     * Describes the URL.
     *
     * @maps cancel_url
     */
    public function setCancelUrl(?string $cancelUrl): void
    {
        $this->cancelUrl = $cancelUrl;
    }

    /**
     * Returns Consumer Ip.
     * An Internet Protocol address (IP address). This address assigns a numerical label to each device
     * that is connected to a computer network through the Internet Protocol. Supports IPv4 and IPv6
     * addresses.
     */
    public function getConsumerIp(): ?string
    {
        return $this->consumerIp;
    }

    /**
     * Sets Consumer Ip.
     * An Internet Protocol address (IP address). This address assigns a numerical label to each device
     * that is connected to a computer network through the Internet Protocol. Supports IPv4 and IPv6
     * addresses.
     *
     * @maps consumer_ip
     */
    public function setConsumerIp(?string $consumerIp): void
    {
        $this->consumerIp = $consumerIp;
    }

    /**
     * Returns Consumer User Agent.
     * The payer's User Agent. For example, Mozilla/5.0 (Macintosh; Intel Mac OS X x.y; rv:42.0).
     */
    public function getConsumerUserAgent(): ?string
    {
        return $this->consumerUserAgent;
    }

    /**
     * Sets Consumer User Agent.
     * The payer's User Agent. For example, Mozilla/5.0 (Macintosh; Intel Mac OS X x.y; rv:42.0).
     *
     * @maps consumer_user_agent
     */
    public function setConsumerUserAgent(?string $consumerUserAgent): void
    {
        $this->consumerUserAgent = $consumerUserAgent;
    }

    /**
     * Converts the BlikExperienceContext object to a human-readable string representation.
     *
     * @return string The string representation of the BlikExperienceContext object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'BlikExperienceContext',
            [
                'brandName' => $this->brandName,
                'locale' => $this->locale,
                'shippingPreference' => $this->shippingPreference,
                'returnUrl' => $this->returnUrl,
                'cancelUrl' => $this->cancelUrl,
                'consumerIp' => $this->consumerIp,
                'consumerUserAgent' => $this->consumerUserAgent
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->brandName)) {
            $json['brand_name']          = $this->brandName;
        }
        if (isset($this->locale)) {
            $json['locale']              = $this->locale;
        }
        if (isset($this->shippingPreference)) {
            $json['shipping_preference'] = $this->shippingPreference;
        }
        if (isset($this->returnUrl)) {
            $json['return_url']          = $this->returnUrl;
        }
        if (isset($this->cancelUrl)) {
            $json['cancel_url']          = $this->cancelUrl;
        }
        if (isset($this->consumerIp)) {
            $json['consumer_ip']         = $this->consumerIp;
        }
        if (isset($this->consumerUserAgent)) {
            $json['consumer_user_agent'] = $this->consumerUserAgent;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
