<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\OrderUpdateCallbackResponse;
use PaypalServerSdkLib\Models\ShippingOptionsPurchaseUnit;

/**
 * Builder for model OrderUpdateCallbackResponse
 *
 * @see OrderUpdateCallbackResponse
 */
class OrderUpdateCallbackResponseBuilder
{
    /**
     * @var OrderUpdateCallbackResponse
     */
    private $instance;

    private function __construct(OrderUpdateCallbackResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Order Update Callback Response Builder object.
     */
    public static function init(): self
    {
        return new self(new OrderUpdateCallbackResponse());
    }

    /**
     * Sets id field.
     *
     * @param string|null $value
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets purchase units field.
     *
     * @param ShippingOptionsPurchaseUnit|null $value
     */
    public function purchaseUnits(?ShippingOptionsPurchaseUnit $value): self
    {
        $this->instance->setPurchaseUnits($value);
        return $this;
    }

    /**
     * Initializes a new Order Update Callback Response object.
     */
    public function build(): OrderUpdateCallbackResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
