<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\OrderUpdateCallbackShippingAddress;

/**
 * Builder for model OrderUpdateCallbackShippingAddress
 *
 * @see OrderUpdateCallbackShippingAddress
 */
class OrderUpdateCallbackShippingAddressBuilder
{
    /**
     * @var OrderUpdateCallbackShippingAddress
     */
    private $instance;

    private function __construct(OrderUpdateCallbackShippingAddress $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Order Update Callback Shipping Address Builder object.
     *
     * @param string $countryCode
     */
    public static function init(string $countryCode): self
    {
        return new self(new OrderUpdateCallbackShippingAddress($countryCode));
    }

    /**
     * Sets admin area 2 field.
     *
     * @param string|null $value
     */
    public function adminArea2(?string $value): self
    {
        $this->instance->setAdminArea2($value);
        return $this;
    }

    /**
     * Sets admin area 1 field.
     *
     * @param string|null $value
     */
    public function adminArea1(?string $value): self
    {
        $this->instance->setAdminArea1($value);
        return $this;
    }

    /**
     * Sets postal code field.
     *
     * @param string|null $value
     */
    public function postalCode(?string $value): self
    {
        $this->instance->setPostalCode($value);
        return $this;
    }

    /**
     * Initializes a new Order Update Callback Shipping Address object.
     */
    public function build(): OrderUpdateCallbackShippingAddress
    {
        return CoreHelper::clone($this->instance);
    }
}
