<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\OrderUpdateCallbackShippingOption;

/**
 * Builder for model OrderUpdateCallbackShippingOption
 *
 * @see OrderUpdateCallbackShippingOption
 */
class OrderUpdateCallbackShippingOptionBuilder
{
    /**
     * @var OrderUpdateCallbackShippingOption
     */
    private $instance;

    private function __construct(OrderUpdateCallbackShippingOption $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Order Update Callback Shipping Option Builder object.
     *
     * @param string $id
     * @param string $label
     */
    public static function init(string $id, string $label): self
    {
        return new self(new OrderUpdateCallbackShippingOption($id, $label));
    }

    /**
     * Sets type field.
     *
     * @param string|null $value
     */
    public function type(?string $value): self
    {
        $this->instance->setType($value);
        return $this;
    }

    /**
     * Sets amount field.
     *
     * @param Money|null $value
     */
    public function amount(?Money $value): self
    {
        $this->instance->setAmount($value);
        return $this;
    }

    /**
     * Initializes a new Order Update Callback Shipping Option object.
     */
    public function build(): OrderUpdateCallbackShippingOption
    {
        return CoreHelper::clone($this->instance);
    }
}
