<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PaymentsProcessorResponse;

/**
 * Builder for model PaymentsProcessorResponse
 *
 * @see PaymentsProcessorResponse
 */
class PaymentsProcessorResponseBuilder
{
    /**
     * @var PaymentsProcessorResponse
     */
    private $instance;

    private function __construct(PaymentsProcessorResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Payments Processor Response Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentsProcessorResponse());
    }

    /**
     * Sets avs code field.
     *
     * @param string|null $value
     */
    public function avsCode(?string $value): self
    {
        $this->instance->setAvsCode($value);
        return $this;
    }

    /**
     * Sets cvv code field.
     *
     * @param string|null $value
     */
    public function cvvCode(?string $value): self
    {
        $this->instance->setCvvCode($value);
        return $this;
    }

    /**
     * Sets response code field.
     *
     * @param string|null $value
     */
    public function responseCode(?string $value): self
    {
        $this->instance->setResponseCode($value);
        return $this;
    }

    /**
     * Sets payment advice code field.
     *
     * @param string|null $value
     */
    public function paymentAdviceCode(?string $value): self
    {
        $this->instance->setPaymentAdviceCode($value);
        return $this;
    }

    /**
     * Initializes a new Payments Processor Response object.
     */
    public function build(): PaymentsProcessorResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
