<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\AmountWithBreakdown;
use PaypalServerSdkLib\Models\Item;
use PaypalServerSdkLib\Models\ShippingOption;
use PaypalServerSdkLib\Models\ShippingOptionsPurchaseUnit;

/**
 * Builder for model ShippingOptionsPurchaseUnit
 *
 * @see ShippingOptionsPurchaseUnit
 */
class ShippingOptionsPurchaseUnitBuilder
{
    /**
     * @var ShippingOptionsPurchaseUnit
     */
    private $instance;

    private function __construct(ShippingOptionsPurchaseUnit $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Shipping Options Purchase Unit Builder object.
     */
    public static function init(): self
    {
        return new self(new ShippingOptionsPurchaseUnit());
    }

    /**
     * Sets reference id field.
     *
     * @param string|null $value
     */
    public function referenceId(?string $value): self
    {
        $this->instance->setReferenceId($value);
        return $this;
    }

    /**
     * Sets amount field.
     *
     * @param AmountWithBreakdown|null $value
     */
    public function amount(?AmountWithBreakdown $value): self
    {
        $this->instance->setAmount($value);
        return $this;
    }

    /**
     * Sets items field.
     *
     * @param Item[]|null $value
     */
    public function items(?array $value): self
    {
        $this->instance->setItems($value);
        return $this;
    }

    /**
     * Sets shipping options field.
     *
     * @param ShippingOption[]|null $value
     */
    public function shippingOptions(?array $value): self
    {
        $this->instance->setShippingOptions($value);
        return $this;
    }

    /**
     * Initializes a new Shipping Options Purchase Unit object.
     */
    public function build(): ShippingOptionsPurchaseUnit
    {
        return CoreHelper::clone($this->instance);
    }
}
