<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\VaultVenmoExperienceContext;

/**
 * Builder for model VaultVenmoExperienceContext
 *
 * @see VaultVenmoExperienceContext
 */
class VaultVenmoExperienceContextBuilder
{
    /**
     * @var VaultVenmoExperienceContext
     */
    private $instance;

    private function __construct(VaultVenmoExperienceContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Vault Venmo Experience Context Builder object.
     */
    public static function init(): self
    {
        return new self(new VaultVenmoExperienceContext());
    }

    /**
     * Sets brand name field.
     *
     * @param string|null $value
     */
    public function brandName(?string $value): self
    {
        $this->instance->setBrandName($value);
        return $this;
    }

    /**
     * Sets shipping preference field.
     *
     * @param string|null $value
     */
    public function shippingPreference(?string $value): self
    {
        $this->instance->setShippingPreference($value);
        return $this;
    }

    /**
     * Sets vault instruction field.
     *
     * @param string|null $value
     */
    public function vaultInstruction(?string $value): self
    {
        $this->instance->setVaultInstruction($value);
        return $this;
    }

    /**
     * Initializes a new Vault Venmo Experience Context object.
     */
    public function build(): VaultVenmoExperienceContext
    {
        return CoreHelper::clone($this->instance);
    }
}
