<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The error details.
 */
class OrderUpdateCallbackErrorResponse implements \JsonSerializable
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var string|null
     */
    private $message;

    /**
     * @var OrderUpdateCallbackErrorResponseDetails[]|null
     */
    private $details;

    /**
     * @param string $name
     */
    public function __construct(string $name)
    {
        $this->name = $name;
    }

    /**
     * Returns Name.
     * The human-readable, unique name of the error.
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * Sets Name.
     * The human-readable, unique name of the error.
     *
     * @required
     * @maps name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns Message.
     * The message that describes the error.
     */
    public function getMessage(): ?string
    {
        return $this->message;
    }

    /**
     * Sets Message.
     * The message that describes the error.
     *
     * @maps message
     */
    public function setMessage(?string $message): void
    {
        $this->message = $message;
    }

    /**
     * Returns Details.
     * An array of additional details about the error.
     *
     * @return OrderUpdateCallbackErrorResponseDetails[]|null
     */
    public function getDetails(): ?array
    {
        return $this->details;
    }

    /**
     * Sets Details.
     * An array of additional details about the error.
     *
     * @maps details
     *
     * @param OrderUpdateCallbackErrorResponseDetails[]|null $details
     */
    public function setDetails(?array $details): void
    {
        $this->details = $details;
    }

    /**
     * Converts the OrderUpdateCallbackErrorResponse object to a human-readable string representation.
     *
     * @return string The string representation of the OrderUpdateCallbackErrorResponse object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'OrderUpdateCallbackErrorResponse',
            ['name' => $this->name, 'message' => $this->message, 'details' => $this->details]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['name']        = $this->name;
        if (isset($this->message)) {
            $json['message'] = $this->message;
        }
        if (isset($this->details)) {
            $json['details'] = $this->details;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
