<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The error details. Required for client-side `4XX` errors.
 */
class OrderUpdateCallbackErrorResponseDetails implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $field;

    /**
     * @var string|null
     */
    private $value;

    /**
     * @var string
     */
    private $issue;

    /**
     * @param string $issue
     */
    public function __construct(string $issue)
    {
        $this->issue = $issue;
    }

    /**
     * Returns Field.
     * The field that caused the error. If this field is in the body, set this value to the field's JSON
     * pointer value. Required for client-side errors.
     */
    public function getField(): ?string
    {
        return $this->field;
    }

    /**
     * Sets Field.
     * The field that caused the error. If this field is in the body, set this value to the field's JSON
     * pointer value. Required for client-side errors.
     *
     * @maps field
     */
    public function setField(?string $field): void
    {
        $this->field = $field;
    }

    /**
     * Returns Value.
     * The value of the field that caused the error.
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * Sets Value.
     * The value of the field that caused the error.
     *
     * @maps value
     */
    public function setValue(?string $value): void
    {
        $this->value = $value;
    }

    /**
     * Returns Issue.
     * The unique, fine-grained application-level error code.
     */
    public function getIssue(): string
    {
        return $this->issue;
    }

    /**
     * Sets Issue.
     * The unique, fine-grained application-level error code.
     *
     * @required
     * @maps issue
     */
    public function setIssue(string $issue): void
    {
        $this->issue = $issue;
    }

    /**
     * Converts the OrderUpdateCallbackErrorResponseDetails object to a human-readable string
     * representation.
     *
     * @return string The string representation of the OrderUpdateCallbackErrorResponseDetails object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'OrderUpdateCallbackErrorResponseDetails',
            ['field' => $this->field, 'value' => $this->value, 'issue' => $this->issue]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->field)) {
            $json['field'] = $this->field;
        }
        if (isset($this->value)) {
            $json['value'] = $this->value;
        }
        $json['issue']     = $this->issue;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
