<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Shipping Options Callback request. This will be implemented by the merchants.
 */
class OrderUpdateCallbackRequest implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $id;

    /**
     * @var OrderUpdateCallbackShippingAddress
     */
    private $shippingAddress;

    /**
     * @var OrderUpdateCallbackShippingOption|null
     */
    private $shippingOption;

    /**
     * @var PurchaseUnitRequest[]
     */
    private $purchaseUnits;

    /**
     * @param OrderUpdateCallbackShippingAddress $shippingAddress
     * @param PurchaseUnitRequest[] $purchaseUnits
     */
    public function __construct(OrderUpdateCallbackShippingAddress $shippingAddress, array $purchaseUnits)
    {
        $this->shippingAddress = $shippingAddress;
        $this->purchaseUnits = $purchaseUnits;
    }

    /**
     * Returns Id.
     * The ID of the order.
     */
    public function getId(): ?string
    {
        return $this->id;
    }

    /**
     * Sets Id.
     * The ID of the order.
     *
     * @maps id
     */
    public function setId(?string $id): void
    {
        $this->id = $id;
    }

    /**
     * Returns Shipping Address.
     * The portable international postal address. Maps to [AddressValidationMetadata](https://github.
     * com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form
     * controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-
     * controls-the-autocomplete-attribute).
     */
    public function getShippingAddress(): OrderUpdateCallbackShippingAddress
    {
        return $this->shippingAddress;
    }

    /**
     * Sets Shipping Address.
     * The portable international postal address. Maps to [AddressValidationMetadata](https://github.
     * com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form
     * controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-
     * controls-the-autocomplete-attribute).
     *
     * @required
     * @maps shipping_address
     */
    public function setShippingAddress(OrderUpdateCallbackShippingAddress $shippingAddress): void
    {
        $this->shippingAddress = $shippingAddress;
    }

    /**
     * Returns Shipping Option.
     * The options that the payee or merchant offers to the payer to ship or pick up their items.
     */
    public function getShippingOption(): ?OrderUpdateCallbackShippingOption
    {
        return $this->shippingOption;
    }

    /**
     * Sets Shipping Option.
     * The options that the payee or merchant offers to the payer to ship or pick up their items.
     *
     * @maps shipping_option
     */
    public function setShippingOption(?OrderUpdateCallbackShippingOption $shippingOption): void
    {
        $this->shippingOption = $shippingOption;
    }

    /**
     * Returns Purchase Units.
     * An array of purchase units. At present only 1 purchase_unit is supported. Each purchase unit
     * establishes a contract between a payer and the payee. Each purchase unit represents either a full or
     * partial order that the payer intends to purchase from the payee.
     *
     * @return PurchaseUnitRequest[]
     */
    public function getPurchaseUnits(): array
    {
        return $this->purchaseUnits;
    }

    /**
     * Sets Purchase Units.
     * An array of purchase units. At present only 1 purchase_unit is supported. Each purchase unit
     * establishes a contract between a payer and the payee. Each purchase unit represents either a full or
     * partial order that the payer intends to purchase from the payee.
     *
     * @required
     * @maps purchase_units
     *
     * @param PurchaseUnitRequest[] $purchaseUnits
     */
    public function setPurchaseUnits(array $purchaseUnits): void
    {
        $this->purchaseUnits = $purchaseUnits;
    }

    /**
     * Converts the OrderUpdateCallbackRequest object to a human-readable string representation.
     *
     * @return string The string representation of the OrderUpdateCallbackRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'OrderUpdateCallbackRequest',
            [
                'id' => $this->id,
                'shippingAddress' => $this->shippingAddress,
                'shippingOption' => $this->shippingOption,
                'purchaseUnits' => $this->purchaseUnits
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->id)) {
            $json['id']              = $this->id;
        }
        $json['shipping_address']    = $this->shippingAddress;
        if (isset($this->shippingOption)) {
            $json['shipping_option'] = $this->shippingOption;
        }
        $json['purchase_units']      = $this->purchaseUnits;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
