<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Returns the updated shipping options for an order.
 */
class OrderUpdateCallbackResponse implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $id;

    /**
     * @var ShippingOptionsPurchaseUnit|null
     */
    private $purchaseUnits;

    /**
     * Returns Id.
     * The ID of the order.
     */
    public function getId(): ?string
    {
        return $this->id;
    }

    /**
     * Sets Id.
     * The ID of the order.
     *
     * @maps id
     */
    public function setId(?string $id): void
    {
        $this->id = $id;
    }

    /**
     * Returns Purchase Units.
     * This would contain shipping option and amount data at purchase unit level.
     */
    public function getPurchaseUnits(): ?ShippingOptionsPurchaseUnit
    {
        return $this->purchaseUnits;
    }

    /**
     * Sets Purchase Units.
     * This would contain shipping option and amount data at purchase unit level.
     *
     * @maps purchase_units
     */
    public function setPurchaseUnits(?ShippingOptionsPurchaseUnit $purchaseUnits): void
    {
        $this->purchaseUnits = $purchaseUnits;
    }

    /**
     * Converts the OrderUpdateCallbackResponse object to a human-readable string representation.
     *
     * @return string The string representation of the OrderUpdateCallbackResponse object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'OrderUpdateCallbackResponse',
            ['id' => $this->id, 'purchaseUnits' => $this->purchaseUnits]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->id)) {
            $json['id']             = $this->id;
        }
        if (isset($this->purchaseUnits)) {
            $json['purchase_units'] = $this->purchaseUnits;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
