<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Provides additional details to process a payment using the PayPal wallet billing agreement or a
 * vaulted payment method that has been stored or is intended to be stored.
 */
class PaypalWalletStoredCredential implements \JsonSerializable
{
    /**
     * @var string
     */
    private $paymentInitiator;

    /**
     * @var string|null
     */
    private $chargePattern;

    /**
     * @var string|null
     */
    private $usagePattern;

    /**
     * @var string|null
     */
    private $usage = StoredPaymentSourceUsageType::DERIVED;

    /**
     * @param string $paymentInitiator
     */
    public function __construct(string $paymentInitiator)
    {
        $this->paymentInitiator = $paymentInitiator;
    }

    /**
     * Returns Payment Initiator.
     * The person or party who initiated or triggered the payment.
     */
    public function getPaymentInitiator(): string
    {
        return $this->paymentInitiator;
    }

    /**
     * Sets Payment Initiator.
     * The person or party who initiated or triggered the payment.
     *
     * @required
     * @maps payment_initiator
     */
    public function setPaymentInitiator(string $paymentInitiator): void
    {
        $this->paymentInitiator = $paymentInitiator;
    }

    /**
     * Returns Charge Pattern.
     * Expected business/pricing model for the billing agreement.
     */
    public function getChargePattern(): ?string
    {
        return $this->chargePattern;
    }

    /**
     * Sets Charge Pattern.
     * Expected business/pricing model for the billing agreement.
     *
     * @maps charge_pattern
     */
    public function setChargePattern(?string $chargePattern): void
    {
        $this->chargePattern = $chargePattern;
    }

    /**
     * Returns Usage Pattern.
     * Expected business/pricing model for the billing agreement.
     */
    public function getUsagePattern(): ?string
    {
        return $this->usagePattern;
    }

    /**
     * Sets Usage Pattern.
     * Expected business/pricing model for the billing agreement.
     *
     * @maps usage_pattern
     */
    public function setUsagePattern(?string $usagePattern): void
    {
        $this->usagePattern = $usagePattern;
    }

    /**
     * Returns Usage.
     * Indicates if this is a `first` or `subsequent` payment using a stored payment source (also referred
     * to as stored credential or card on file).
     */
    public function getUsage(): ?string
    {
        return $this->usage;
    }

    /**
     * Sets Usage.
     * Indicates if this is a `first` or `subsequent` payment using a stored payment source (also referred
     * to as stored credential or card on file).
     *
     * @maps usage
     */
    public function setUsage(?string $usage): void
    {
        $this->usage = $usage;
    }

    /**
     * Converts the PaypalWalletStoredCredential object to a human-readable string representation.
     *
     * @return string The string representation of the PaypalWalletStoredCredential object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PaypalWalletStoredCredential',
            [
                'paymentInitiator' => $this->paymentInitiator,
                'chargePattern' => $this->chargePattern,
                'usagePattern' => $this->usagePattern,
                'usage' => $this->usage
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['payment_initiator']  = $this->paymentInitiator;
        if (isset($this->chargePattern)) {
            $json['charge_pattern'] = $this->chargePattern;
        }
        if (isset($this->usagePattern)) {
            $json['usage_pattern']  = $this->usagePattern;
        }
        if (isset($this->usage)) {
            $json['usage']          = $this->usage;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
