<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * This would contain shipping option and amount data at purchase unit level.
 */
class ShippingOptionsPurchaseUnit implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $referenceId;

    /**
     * @var AmountWithBreakdown|null
     */
    private $amount;

    /**
     * @var Item[]|null
     */
    private $items;

    /**
     * @var ShippingOption[]|null
     */
    private $shippingOptions;

    /**
     * Returns Reference Id.
     * The API caller-provided external ID for the purchase unit. Required for multiple purchase units when
     * you must update the order through `PATCH`. If you omit this value and the order contains only one
     * purchase unit, PayPal sets this value to `default`. Note: If there are multiple purchase units,
     * reference_id is required for each purchase unit.
     */
    public function getReferenceId(): ?string
    {
        return $this->referenceId;
    }

    /**
     * Sets Reference Id.
     * The API caller-provided external ID for the purchase unit. Required for multiple purchase units when
     * you must update the order through `PATCH`. If you omit this value and the order contains only one
     * purchase unit, PayPal sets this value to `default`. Note: If there are multiple purchase units,
     * reference_id is required for each purchase unit.
     *
     * @maps reference_id
     */
    public function setReferenceId(?string $referenceId): void
    {
        $this->referenceId = $referenceId;
    }

    /**
     * Returns Amount.
     * The total order amount with an optional breakdown that provides details, such as the total item
     * amount, total tax amount, shipping, handling, insurance, and discounts, if any. If you specify
     * `amount.breakdown`, the amount equals `item_total` plus `tax_total` plus `shipping` plus `handling`
     * plus `insurance` minus `shipping_discount` minus discount. The amount must be a positive number. For
     * listed of supported currencies and decimal precision, see the PayPal REST APIs Currency Codes.
     */
    public function getAmount(): ?AmountWithBreakdown
    {
        return $this->amount;
    }

    /**
     * Sets Amount.
     * The total order amount with an optional breakdown that provides details, such as the total item
     * amount, total tax amount, shipping, handling, insurance, and discounts, if any. If you specify
     * `amount.breakdown`, the amount equals `item_total` plus `tax_total` plus `shipping` plus `handling`
     * plus `insurance` minus `shipping_discount` minus discount. The amount must be a positive number. For
     * listed of supported currencies and decimal precision, see the PayPal REST APIs Currency Codes.
     *
     * @maps amount
     */
    public function setAmount(?AmountWithBreakdown $amount): void
    {
        $this->amount = $amount;
    }

    /**
     * Returns Items.
     * An array of items that the customer purchases from the merchant.
     *
     * @return Item[]|null
     */
    public function getItems(): ?array
    {
        return $this->items;
    }

    /**
     * Sets Items.
     * An array of items that the customer purchases from the merchant.
     *
     * @maps items
     *
     * @param Item[]|null $items
     */
    public function setItems(?array $items): void
    {
        $this->items = $items;
    }

    /**
     * Returns Shipping Options.
     * An array of shipping options that the payee or merchant offers to the payer to ship or pick up their
     * items.
     *
     * @return ShippingOption[]|null
     */
    public function getShippingOptions(): ?array
    {
        return $this->shippingOptions;
    }

    /**
     * Sets Shipping Options.
     * An array of shipping options that the payee or merchant offers to the payer to ship or pick up their
     * items.
     *
     * @maps shipping_options
     *
     * @param ShippingOption[]|null $shippingOptions
     */
    public function setShippingOptions(?array $shippingOptions): void
    {
        $this->shippingOptions = $shippingOptions;
    }

    /**
     * Converts the ShippingOptionsPurchaseUnit object to a human-readable string representation.
     *
     * @return string The string representation of the ShippingOptionsPurchaseUnit object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'ShippingOptionsPurchaseUnit',
            [
                'referenceId' => $this->referenceId,
                'amount' => $this->amount,
                'items' => $this->items,
                'shippingOptions' => $this->shippingOptions
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->referenceId)) {
            $json['reference_id']     = $this->referenceId;
        }
        if (isset($this->amount)) {
            $json['amount']           = $this->amount;
        }
        if (isset($this->items)) {
            $json['items']            = $this->items;
        }
        if (isset($this->shippingOptions)) {
            $json['shipping_options'] = $this->shippingOptions;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
