<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Customizes the buyer experience during the approval process for payment with Venmo. Note: Partners
 * and Marketplaces might configure shipping_preference during partner account setup, which overrides
 * the request values.
 */
class VenmoWalletExperienceContext implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $brandName;

    /**
     * @var string|null
     */
    private $shippingPreference = ShippingPreference::GET_FROM_FILE;

    /**
     * @var CallbackConfiguration|null
     */
    private $orderUpdateCallbackConfig;

    /**
     * Returns Brand Name.
     * The business name of the merchant. The pattern is defined by an external party and supports Unicode.
     */
    public function getBrandName(): ?string
    {
        return $this->brandName;
    }

    /**
     * Sets Brand Name.
     * The business name of the merchant. The pattern is defined by an external party and supports Unicode.
     *
     * @maps brand_name
     */
    public function setBrandName(?string $brandName): void
    {
        $this->brandName = $brandName;
    }

    /**
     * Returns Shipping Preference.
     * The location from which the shipping address is derived.
     */
    public function getShippingPreference(): ?string
    {
        return $this->shippingPreference;
    }

    /**
     * Sets Shipping Preference.
     * The location from which the shipping address is derived.
     *
     * @maps shipping_preference
     */
    public function setShippingPreference(?string $shippingPreference): void
    {
        $this->shippingPreference = $shippingPreference;
    }

    /**
     * Returns Order Update Callback Config.
     * CallBack Configuration that the merchant can provide to PayPal/Venmo.
     */
    public function getOrderUpdateCallbackConfig(): ?CallbackConfiguration
    {
        return $this->orderUpdateCallbackConfig;
    }

    /**
     * Sets Order Update Callback Config.
     * CallBack Configuration that the merchant can provide to PayPal/Venmo.
     *
     * @maps order_update_callback_config
     */
    public function setOrderUpdateCallbackConfig(?CallbackConfiguration $orderUpdateCallbackConfig): void
    {
        $this->orderUpdateCallbackConfig = $orderUpdateCallbackConfig;
    }

    /**
     * Converts the VenmoWalletExperienceContext object to a human-readable string representation.
     *
     * @return string The string representation of the VenmoWalletExperienceContext object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'VenmoWalletExperienceContext',
            [
                'brandName' => $this->brandName,
                'shippingPreference' => $this->shippingPreference,
                'orderUpdateCallbackConfig' => $this->orderUpdateCallbackConfig
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->brandName)) {
            $json['brand_name']                   = $this->brandName;
        }
        if (isset($this->shippingPreference)) {
            $json['shipping_preference']          = $this->shippingPreference;
        }
        if (isset($this->orderUpdateCallbackConfig)) {
            $json['order_update_callback_config'] = $this->orderUpdateCallbackConfig;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
